/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;

public class IESaveData
extends WorldSavedData {
    private static IESaveData INSTANCE;
    public static final String dataName = "ImmersiveEngineering-SaveData";

    public IESaveData() {
        super(dataName);
    }

    public void func_76184_a(CompoundNBT nbt) {
        EventHandler.validateConnsNextTick = true;
        ListNBT mineralList = nbt.func_150295_c("mineralDepletion", 10);
        ExcavatorHandler.mineralCache.clear();
        for (int i = 0; i < mineralList.size(); ++i) {
            CompoundNBT tag = mineralList.func_150305_b(i);
            DimensionChunkCoords coords = DimensionChunkCoords.readFromNBT(tag);
            if (coords == null) continue;
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.MineralWorldInfo.readFromNBT(tag.func_74775_l("info"));
            ExcavatorHandler.mineralCache.put(coords, info);
        }
        ListNBT receivedShaderList = nbt.func_150295_c("receivedShaderList", 10);
        for (int i = 0; i < receivedShaderList.size(); ++i) {
            CompoundNBT tag = receivedShaderList.func_150305_b(i);
            UUID player = tag.func_186857_a("player");
            ShaderRegistry.receivedShaders.get((Object)player).clear();
            ListNBT playerReceived = tag.func_150295_c("received", 8);
            for (int j = 0; j < playerReceived.size(); ++j) {
                String s = playerReceived.func_150307_f(j);
                if (s.isEmpty()) continue;
                ShaderRegistry.receivedShaders.put((Object)player, (Object)new ResourceLocation(s));
            }
        }
    }

    @Nonnull
    public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbt) {
        ListNBT mineralList = new ListNBT();
        for (Map.Entry<DimensionChunkCoords, ExcavatorHandler.MineralWorldInfo> e : ExcavatorHandler.mineralCache.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            CompoundNBT tag = e.getKey().writeToNBT();
            tag.func_218657_a("info", (INBT)e.getValue().writeToNBT());
            mineralList.add((Object)tag);
        }
        nbt.func_218657_a("mineralDepletion", (INBT)mineralList);
        ListNBT receivedShaderList = new ListNBT();
        for (UUID player : ShaderRegistry.receivedShaders.keySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("player", player);
            ListNBT playerReceived = new ListNBT();
            for (ResourceLocation shader : ShaderRegistry.receivedShaders.get((Object)player)) {
                if (shader == null) continue;
                playerReceived.add((Object)StringNBT.func_229705_a_((String)shader.toString()));
            }
            tag.func_218657_a("received", (INBT)playerReceived);
            receivedShaderList.add((Object)tag);
        }
        nbt.func_218657_a("receivedShaderList", (INBT)receivedShaderList);
        return nbt;
    }

    public static void setDirty() {
        INSTANCE.func_76185_a();
    }

    public static void setInstance(IESaveData in) {
        INSTANCE = in;
    }
}

