/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.DynamicModelLoader;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.SinglePropertyModelData;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceTileEntity;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;

public class ArcFurnaceRenderer
extends TileEntityRenderer<ArcFurnaceTileEntity> {
    private TextureAtlasSprite hotMetal_flow = null;
    private TextureAtlasSprite hotMetal_still = null;
    private final DynamicModel<Direction> electrodes = DynamicModel.createSided(new ResourceLocation("immersiveengineering", "block/metal_multiblock/arc_furnace_electrodes.obj.ie"), "arc_furnace_electrodes", DynamicModel.ModelType.IE_OBJ);
    private static final ResourceLocation HOT_METLA_STILL = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_still");
    private static final ResourceLocation HOT_METLA_FLOW = new ResourceLocation("immersiveengineering", "block/fluid/hot_metal_flow");

    public ArcFurnaceRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        DynamicModelLoader.requestTexture(HOT_METLA_FLOW);
        DynamicModelLoader.requestTexture(HOT_METLA_STILL);
    }

    public void render(ArcFurnaceTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!te.formed || te.isDummy() || !te.getWorldNonnull().func_175667_e(te.func_174877_v())) {
            return;
        }
        List renderedParts = null;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)te.getInventory().get(23 + i)).func_190926_b()) continue;
            if (renderedParts == null) {
                renderedParts = Lists.newArrayList((Object[])new String[]{"electrode" + (i + 1)});
                continue;
            }
            renderedParts.add("electrode" + (i + 1));
        }
        if (renderedParts == null) {
            return;
        }
        if (te.shouldRenderAsActive()) {
            renderedParts.add("active");
        }
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        BlockPos blockPos = te.func_174877_v();
        BlockState state = te.func_145831_w().func_180495_p(blockPos);
        if (state.func_177230_c() != IEBlocks.Multiblocks.arcFurnace) {
            return;
        }
        IBakedModel model = this.electrodes.get(te.getFacing());
        IEProperties.IEObjState objState = new IEProperties.IEObjState(IEProperties.VisibilityList.show(renderedParts));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        blockRenderer.func_175019_b().renderModel((ILightReader)te.getWorldNonnull(), model, state, blockPos, matrixStack, bufferIn.getBuffer(RenderType.func_228639_c_()), true, te.func_145831_w().field_73012_v, 0L, 0, new SinglePropertyModelData<IEProperties.IEObjState>(objState, IEProperties.Model.IE_OBJ_STATE));
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (te.pouringMetal > 0) {
            if (this.hotMetal_flow == null) {
                AtlasTexture blockMap = ClientUtils.mc().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_);
                this.hotMetal_still = blockMap.func_195424_a(HOT_METLA_STILL);
                this.hotMetal_flow = blockMap.func_195424_a(HOT_METLA_FLOW);
            }
            matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -te.getFacing().func_185119_l() + 180.0f, true));
            int process = 40;
            float speed = 5.0f;
            int pour = process - te.pouringMetal;
            float h = ((float)pour > (float)process - speed ? (float)(process - pour) / speed * 27.0f : ((float)pour > speed ? 27.0f : (float)pour / speed * 27.0f)) / 16.0f;
            matrixStack.func_227861_a_(-0.5, 0.5625, 1.5);
            IVertexBuilder fullbright = bufferIn.getBuffer(IERenderTypes.SOLID_FULLBRIGHT);
            matrixStack.func_227860_a_();
            if ((float)pour > (float)process - speed) {
                matrixStack.func_227861_a_(0.0, (double)(-1.6875f + h), 0.0);
            }
            if (h > 1.0f) {
                matrixStack.func_227861_a_(0.0, (double)(-h), 0.0);
                ClientUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.func_227861_a_(0.0, 1.0, 0.0);
                ClientUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h - 1.0f, 0.625f, this.hotMetal_flow, true);
                matrixStack.func_227861_a_(0.0, -1.0, 0.0);
                matrixStack.func_227861_a_(0.0, (double)h, 0.0);
            } else {
                matrixStack.func_227861_a_(0.0, (double)(-h), 0.0);
                ClientUtils.renderTexturedBox(fullbright, matrixStack, 0.375f, 0.0f, 0.375f, 0.625f, h, 0.625f, this.hotMetal_flow, true);
                matrixStack.func_227861_a_(0.0, (double)h, 0.0);
            }
            if ((float)pour > (float)process - speed) {
                matrixStack.func_227861_a_(0.0, (double)(1.6875f - h), 0.0);
            }
            if ((float)pour > speed) {
                float h2 = (float)pour > (float)process - speed ? 0.625f : (float)pour / ((float)process - speed) * 0.625f;
                matrixStack.func_227861_a_(0.0, -1.6875, 0.0);
                ClientUtils.renderTexturedBox(fullbright, matrixStack, 0.125f, 0.0f, 0.125f, 0.875f, h2, 0.875f, this.hotMetal_still, false);
                matrixStack.func_227861_a_(0.0, 1.6875, 0.0);
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }
}

