/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class IEBipedLayerRenderer<E extends LivingEntity, M extends BipedModel<E>>
extends LayerRenderer<E, M> {
    public static boolean rendersAssigned = false;
    public static Map<UUID, Pair<ItemStack, Integer>> POWERPACK_PLAYERS = new HashMap<UUID, Pair<ItemStack, Integer>>();

    public IEBipedLayerRenderer(IEntityRenderer<E, M> entityRendererIn) {
        super(entityRendererIn);
    }

    @ParametersAreNonnullByDefault
    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, E living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack chest;
        ItemStack head = living.func_184582_a(EquipmentSlotType.HEAD);
        if (!head.func_190926_b() && (head.func_77973_b() == IEItems.Misc.earmuffs || ItemNBTHelper.hasKey(head, "IE:Earmuffs"))) {
            ItemStack earmuffs;
            ItemStack itemStack = earmuffs = head.func_77973_b() == IEItems.Misc.earmuffs ? head : ItemNBTHelper.getItemStack(head, "IE:Earmuffs");
            if (!earmuffs.func_190926_b()) {
                BipedModel model = IEItems.Misc.earmuffs.getArmorModel(living, earmuffs, EquipmentSlotType.HEAD, null);
                model.func_225597_a_(living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                RenderType type = model.func_228282_a_(new ResourceLocation(IEItems.Misc.earmuffs.getArmorTexture(earmuffs, living, EquipmentSlotType.HEAD, "overlay")));
                model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                int colour = ((IEItemInterfaces.IColouredItem)earmuffs.func_77973_b()).getColourForIEItem(earmuffs, 0);
                type = model.func_228282_a_(new ResourceLocation(IEItems.Misc.earmuffs.getArmorTexture(earmuffs, living, EquipmentSlotType.HEAD, null)));
                model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.field_229196_a_, (float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f);
            }
        }
        if (!(chest = living.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && (chest.func_77973_b() == IEItems.Misc.powerpack || ItemNBTHelper.hasKey(chest, "IE:Powerpack"))) {
            ItemStack powerpack = chest.func_77973_b() == IEItems.Misc.powerpack ? chest : ItemNBTHelper.getItemStack(chest, "IE:Powerpack");
            IEBipedLayerRenderer.addWornPowerpack(living, powerpack);
        }
        if (POWERPACK_PLAYERS.containsKey(living.func_110124_au())) {
            Pair<ItemStack, Integer> entry = POWERPACK_PLAYERS.get(living.func_110124_au());
            this.renderPowerpack((ItemStack)entry.getLeft(), matrixStackIn, bufferIn, packedLightIn, living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int time = (Integer)entry.getValue() - 1;
            if (time <= 0) {
                POWERPACK_PLAYERS.remove(living.func_110124_au());
            } else {
                POWERPACK_PLAYERS.put(living.func_110124_au(), (Pair<ItemStack, Integer>)Pair.of((Object)entry.getLeft(), (Object)time));
            }
        }
    }

    public static void addWornPowerpack(LivingEntity living, ItemStack powerpack) {
        POWERPACK_PLAYERS.put(living.func_110124_au(), (Pair<ItemStack, Integer>)Pair.of((Object)powerpack, (Object)5));
    }

    private void renderPowerpack(ItemStack powerpack, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, E living, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!powerpack.func_190926_b()) {
            BipedModel model = IEItems.Misc.powerpack.getArmorModel(living, powerpack, EquipmentSlotType.CHEST, null);
            model.func_225597_a_(living, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RenderType type = model.func_228282_a_(new ResourceLocation(IEItems.Misc.powerpack.getArmorTexture(powerpack, living, EquipmentSlotType.CHEST, null)));
            model.func_225598_a_(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

