/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.models.connection.RenderCacheKey;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.util.Lazy;

public class BakedConnectionModel
extends BakedIEModel {
    Lazy<TextureAtlasSprite> textureAtlasSprite = Lazy.of(() -> Minecraft.func_71410_x().func_209506_al().func_229356_a_(PlayerContainer.field_226615_c_).func_195424_a(new ResourceLocation("immersiveengineering", "block/wire")));
    public static final Cache<ModelKey, IBakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    @Nullable
    private final IBakedModel base;
    private final ImmutableSet<String> layers;

    public BakedConnectionModel(@Nullable IBakedModel basic, Collection<String> layers) {
        this.base = basic;
        this.layers = ImmutableSet.copyOf(layers);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null && extraData.hasProperty(IEProperties.Model.CONNECTIONS)) {
            TileEntity te;
            Object[] additional = null;
            if (extraData.hasProperty(IEProperties.Model.TILEENTITY_PASSTHROUGH) && (te = (TileEntity)extraData.getData(IEProperties.Model.TILEENTITY_PASSTHROUGH)) instanceof IEBlockInterfaces.ICacheData) {
                additional = ((IEBlockInterfaces.ICacheData)te).getCacheData();
            }
            RenderCacheKey ad = new RenderCacheKey(state, null, additional);
            HashSet<Connection.RenderData> data = new HashSet<Connection.RenderData>();
            IEProperties.ConnectionModelData orig = (IEProperties.ConnectionModelData)extraData.getData(IEProperties.Model.CONNECTIONS);
            assert (orig != null);
            for (Connection c : orig.connections) {
                ConnectionPoint here = c.getEndFor(orig.here);
                data.add(new Connection.RenderData(c, c.getEndB().equals(here), ClientUtils.getVertexCountForSide(here, c, 16)));
            }
            ModelKey key = new ModelKey(data, ad, orig.here);
            try {
                IBakedModel ret = (IBakedModel)cache.get((Object)key, () -> new AssembledBakedModel(key, (TextureAtlasSprite)this.textureAtlasSprite.get(), this.base));
                return ret.getQuads(state, null, rand, extraData);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return this.getBaseQuads(MinecraftForgeClient.getRenderLayer(), state, side, rand, extraData);
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        if (this.base != null) {
            return this.base.func_177554_e();
        }
        return ModelLoader.White.instance();
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private List<BakedQuad> getBaseQuads(RenderType currentLayer, BlockState state, Direction side, Random rand, IModelData data) {
        if (this.base != null && (currentLayer == null || this.layers.contains((Object)currentLayer.toString()))) {
            return this.base.getQuads(state, side, rand, data);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull ILightReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        if (this.base == null) {
            return EmptyModelData.INSTANCE;
        }
        return this.base.getModelData(world, pos, state, tileData);
    }

    private static class ModelKey {
        private final Set<Connection.RenderData> connections;
        private final RenderCacheKey state;
        private final BlockPos here;

        private ModelKey(Set<Connection.RenderData> connections, RenderCacheKey state, BlockPos here) {
            this.connections = connections;
            this.state = state;
            this.here = here;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelKey that = (ModelKey)o;
            if (!this.connections.equals(that.connections)) {
                return false;
            }
            return this.state.equals(that.state);
        }

        public int hashCode() {
            int result = this.connections.hashCode();
            result = 31 * result + this.state.hashCode();
            return result;
        }
    }

    public class AssembledBakedModel
    implements IBakedModel {
        ModelKey key;
        List<BakedQuad>[] lists;
        TextureAtlasSprite texture;

        public AssembledBakedModel(ModelKey key, TextureAtlasSprite tex, IBakedModel b) {
            this.key = key;
            this.texture = tex;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            if (layer != RenderType.func_228639_c_()) {
                return BakedConnectionModel.this.getBaseQuads(layer, state, side, rand, data);
            }
            if (this.lists == null) {
                this.lists = ClientUtils.convertConnectionFromBlockstate(this.key.here, this.key.connections, this.texture);
            }
            ArrayList<BakedQuad> l = new ArrayList<BakedQuad>(this.lists[0]);
            l.addAll(BakedConnectionModel.this.getBaseQuads(layer, state, side, rand, data));
            return Collections.synchronizedList(l);
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return false;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_230044_c_() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

