/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.data.IModelData;

public class ModelItemDynamicOverride
extends BakedIEModel {
    IBakedModel itemModel;
    ImmutableList<BakedQuad> quads;
    IBakedModel guiModel;
    public static final HashMap<String, IBakedModel> modelCache = new HashMap();
    static ItemOverrideList dynamicOverrides = new ItemOverrideList(){

        @Nullable
        public IBakedModel func_209581_a(@Nonnull IBakedModel originalModel, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
            IEItemInterfaces.ITextureOverride texOverride;
            String key;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof IEItemInterfaces.ITextureOverride && (key = (texOverride = (IEItemInterfaces.ITextureOverride)stack.func_77973_b()).getModelCacheKey(stack)) != null) {
                IBakedModel model = modelCache.get(key);
                if (model == null) {
                    model = new ModelItemDynamicOverride(originalModel, texOverride.getTextures(stack, key));
                    modelCache.put(key, model);
                }
                return model;
            }
            return originalModel;
        }
    };

    public ModelItemDynamicOverride(IBakedModel itemModel, @Nullable List<ResourceLocation> textures) {
        this.itemModel = itemModel;
        if (textures != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < textures.size(); ++i) {
                builder.addAll((Iterable)ItemLayerModel.getQuadsForSprite((int)i, (TextureAtlasSprite)ClientUtils.getSprite(textures.get(i)), (TransformationMatrix)TransformationMatrix.func_227983_a_()));
            }
            this.quads = builder.build();
            this.guiModel = new BakedGuiItemModel(this);
        } else {
            this.guiModel = itemModel;
        }
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (this.quads != null && side == null) {
            return this.quads;
        }
        return this.itemModel.func_200117_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.itemModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.itemModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.itemModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.itemModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.itemModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return dynamicOverrides;
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack matrixStack) {
        return cameraTransformType == ItemCameraTransforms.TransformType.GUI ? this.guiModel : this;
    }

    public static class BakedGuiItemModel
    extends BakedModelWrapper<ModelItemDynamicOverride> {
        private final ImmutableList<BakedQuad> quads;

        public BakedGuiItemModel(ModelItemDynamicOverride originalModel) {
            super((IBakedModel)originalModel);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : originalModel.quads) {
                if (quad.func_178210_d() != Direction.SOUTH) continue;
                builder.add((Object)quad);
            }
            this.quads = builder.build();
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Nonnull
        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return ((ModelItemDynamicOverride)this.originalModel).itemModel.handlePerspective(cameraTransformType, mat);
        }
    }
}

