/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.network.MessageShaderManual;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.Tree;
import com.electronwill.nightconfig.core.Config;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;

public class IEManualInstance
extends ManualInstance {
    private final Set<ResourceLocation> hiddenEntries = new HashSet<ResourceLocation>();
    private static final ResourceLocation SHADER_ENTRY = new ResourceLocation("immersiveengineering", "shader_list");

    public IEManualInstance() {
        super(new ResourceLocation("immersiveengineering", "textures/gui/manual.png"), 120, 148, new ResourceLocation("immersiveengineering", "manual"));
    }

    @Override
    public String getDefaultResourceDomain() {
        return "immersiveengineering";
    }

    @Override
    public String formatText(String s) {
        String[] segment;
        String rep;
        int end;
        int start;
        String splitKey = ";";
        s = s.replaceAll("<br>", "\n");
        int overflow = 0;
        while ((start = s.indexOf("<config")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            String result = this.formatConfigEntry(rep, splitKey);
            s = s.replaceFirst(rep, result);
        }
        overflow = 0;
        while ((start = s.indexOf("<dim")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            ResourceLocation dimKey = new ResourceLocation(segment[1]);
            StringBuilder dimName = new StringBuilder();
            String[] stringArray = dimKey.func_110623_a().split("_");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String ss = stringArray[i];
                if ("the".equalsIgnoreCase(ss)) continue;
                dimName.append(Utils.toCamelCase(ss) + " ");
            }
            s = s.replaceFirst(rep, dimName.toString().trim());
        }
        overflow = 0;
        while ((start = s.indexOf("<keybind")) >= 0 && overflow < 50) {
            ++overflow;
            end = s.indexOf(">", start);
            rep = s.substring(start, end + 1);
            segment = rep.substring(0, rep.length() - 1).split(splitKey);
            if (segment.length < 2) break;
            String result = "";
            for (KeyBinding kb : ClientUtils.mc().field_71474_y.field_74324_K) {
                if (!segment[1].equalsIgnoreCase(kb.func_151464_g())) continue;
                result = kb.func_197978_k();
                if (result == null || result.length() <= 1) break;
                result = Utils.toCamelCase(result);
                break;
            }
            s = s.replaceFirst(rep, result);
        }
        if (this.improveReadability()) {
            end = 0;
            for (overflow = 0; (start = s.indexOf(TextFormatting.RESET.toString(), end)) >= 0 && overflow < 50; ++overflow) {
                end = start + TextFormatting.RESET.toString().length();
                s = s.substring(0, end) + TextFormatting.BOLD.toString() + s.substring(end);
            }
            s = TextFormatting.BOLD + s;
        }
        return s;
    }

    @Override
    public FontRenderer fontRenderer() {
        FontRenderer ret = ClientUtils.unicodeFontRender();
        if (Minecraft.func_71410_x().field_71474_y.field_74363_ab != null) {
            ret.func_78275_b(ClientUtils.mc().func_135016_M().func_135044_b());
        }
        return ret;
    }

    @Override
    public String getManualName() {
        return I18n.func_135052_a((String)"item.immersiveengineering.tool.manual.name", (Object[])new Object[0]);
    }

    @Override
    public String formatCategoryName(ResourceLocation s) {
        return (this.improveReadability() ? TextFormatting.BOLD : "") + I18n.func_135052_a((String)("manual." + s.toString().replace(':', '.')), (Object[])new Object[0]);
    }

    @Override
    public String formatEntryName(String s) {
        return (this.improveReadability() ? TextFormatting.BOLD : "") + s;
    }

    @Override
    public String formatEntrySubtext(String s) {
        return s;
    }

    public void hideEntry(ResourceLocation name) {
        this.hiddenEntries.add(name);
    }

    @Override
    public boolean showNodeInList(Tree.AbstractNode<ResourceLocation, ManualEntry> node) {
        ResourceLocation nodeLoc;
        ResourceLocation resourceLocation = nodeLoc = node.isLeaf() ? node.getLeafData().getLocation() : node.getNodeData();
        if ("immersiveengineering".equals(nodeLoc.func_110624_b()) && nodeLoc.func_110623_a().startsWith(ManualHelper.CAT_UPDATE)) {
            return (Boolean)IEConfig.GENERAL.showUpdateNews.get();
        }
        return !nodeLoc.equals((Object)SHADER_ENTRY) && !this.hiddenEntries.contains(nodeLoc);
    }

    @Override
    public boolean showCategoryInList(String category) {
        return true;
    }

    @Override
    public String formatLink(ManualInstance.ManualLink link) {
        return TextFormatting.GOLD + "  -> " + link.getKey().getTitle() + ", " + (link.getPage() + 1);
    }

    @Override
    public void openEntry(ManualEntry entry) {
        if (SHADER_ENTRY.equals((Object)entry.getLocation())) {
            ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageShaderManual(MessageShaderManual.MessageType.SYNC, new ResourceLocation[0]));
        }
    }

    @Override
    public int getTitleColour() {
        return 16220212;
    }

    @Override
    public int getSubTitleColour() {
        return 16220212;
    }

    @Override
    public int getTextColour() {
        return this.improveReadability() ? 0 : 0x555555;
    }

    @Override
    public int getHighlightColour() {
        return 13926474;
    }

    @Override
    public int getPagenumberColour() {
        return 10260860;
    }

    @Override
    public boolean allowGuiRescale() {
        return (Boolean)IEConfig.GENERAL.adjustManualScale.get();
    }

    @Override
    public boolean improveReadability() {
        return (Boolean)IEConfig.GENERAL.badEyesight.get();
    }

    public String formatConfigEntry(String rep, String splitKey) {
        Config actualCfg;
        try {
            Field childConfig = ForgeConfigSpec.class.getDeclaredField("childConfig");
            childConfig.setAccessible(true);
            actualCfg = (Config)childConfig.get(IEConfig.ALL);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        String[] segment = rep.substring(0, rep.length() - 1).split(splitKey);
        if (segment.length < 3) {
            return "~ERROR0~";
        }
        if (segment[1].equalsIgnoreCase("b")) {
            if (segment.length > 3) {
                return (Boolean)actualCfg.get(segment[2]) != false ? segment[3] : (segment.length > 4 ? segment[4] : "");
            }
            return "" + actualCfg.get(segment[2]);
        }
        if (segment[1].equalsIgnoreCase("i")) {
            return "" + actualCfg.get(segment[2]);
        }
        if (segment[1].equalsIgnoreCase("iA")) {
            List iA = (List)actualCfg.get(segment[2]);
            if (segment.length > 3) {
                try {
                    if (segment[3].startsWith("l")) {
                        int limiter = Integer.parseInt(segment[3].substring(1));
                        StringBuilder result = new StringBuilder();
                        for (int i = 0; i < limiter; ++i) {
                            result.append(i > 0 ? ", " : "").append(iA.get(i));
                        }
                        return result.toString();
                    }
                    int idx = Integer.parseInt(segment[3]);
                    return "" + iA.get(idx);
                }
                catch (Exception ex) {
                    return "~ERROR1~";
                }
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < iA.size(); ++i) {
                result.append(i > 0 ? ", " : "").append(iA.get(i));
            }
            return result.toString();
        }
        if (segment[1].equalsIgnoreCase("d")) {
            return "" + actualCfg.get(segment[2]);
        }
        if (segment[1].equalsIgnoreCase("dA")) {
            double[] iD = (double[])actualCfg.get(segment[2]);
            if (segment.length > 3) {
                try {
                    int idx = Integer.parseInt(segment[3]);
                    return "" + Utils.formatDouble(iD[idx], "##0.0##");
                }
                catch (Exception ex) {
                    return "~ERROR2~";
                }
            }
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < iD.length; ++i) {
                result.append(i > 0 ? ", " : "").append(Utils.formatDouble(iD[i], "##0.0##"));
            }
            return result.toString();
        }
        return "~ERROR3~";
    }
}

