/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ArcFurnaceTileEntity;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceContainer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArcFurnaceScreen
extends IEContainerScreen<ArcFurnaceContainer> {
    static final String texture = "immersiveengineering:textures/gui/arc_furnace.png";
    private ArcFurnaceTileEntity tile;
    private GuiButtonIE distributeButton;

    public ArcFurnaceScreen(ArcFurnaceContainer container, PlayerInventory inventoryPlayer, ITextComponent title) {
        super(container, inventoryPlayer, title);
        this.field_147000_g = 207;
        this.tile = (ArcFurnaceTileEntity)container.tile;
    }

    @Override
    public void render(int mx, int my, float partial) {
        super.render(mx, my, partial);
        ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
        if (mx > this.field_147003_i + 157 && mx < this.field_147003_i + 164 && my > this.field_147009_r + 22 && my < this.field_147009_r + 68) {
            tooltip.add((ITextComponent)new StringTextComponent(this.tile.getEnergyStored(null) + "/" + this.tile.getMaxEnergyStored(null) + " IF"));
        }
        if (this.distributeButton.isHovered()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("gui.immersiveengineering.config.arcfurnace.distribute", new Object[0]));
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.font, this.field_147003_i + this.field_146999_f, -1);
        }
    }

    protected void func_146976_a(float f, int mx, int my) {
        ClientUtils.bindTexture(texture);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (PoweredMultiblockTileEntity.MultiblockProcess process : this.tile.processQueue) {
            if (!(process instanceof PoweredMultiblockTileEntity.MultiblockProcessInMachine)) continue;
            float mod = (float)process.processTick / (float)process.maxTicks;
            int slot = ((PoweredMultiblockTileEntity.MultiblockProcessInMachine)process).getInputSlots()[0];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            this.blit(this.field_147003_i + 27 + slot % 3 * 21, this.field_147009_r + 34 + slot / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
        int stored = (int)(46.0f * ((float)this.tile.getEnergyStored(null) / (float)this.tile.getMaxEnergyStored(null)));
        ClientUtils.drawGradientRect(this.field_147003_i + 157, this.field_147009_r + 22 + (46 - stored), this.field_147003_i + 164, this.field_147009_r + 68, -4909824, -10482944);
    }

    public void init() {
        super.init();
        final Minecraft mc = ClientUtils.mc();
        this.distributeButton = new GuiButtonIE(this.field_147003_i + 10, this.field_147009_r + 10, 16, 16, "", texture, 179, 0, btn -> {
            if (mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                this.autoSplitStacks();
            }
        }){

            public boolean isHovered() {
                return super.isHovered() && mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            }
        }.setHoverOffset(0, 16);
        this.addButton((Widget)this.distributeButton);
    }

    private void autoSplitStacks() {
        for (int j = 0; j < 12; ++j) {
            int emptySlot = -1;
            int largestSlot = -1;
            int largestCount = -1;
            for (int i = 0; i < 12; ++i) {
                if (((ArcFurnaceContainer)this.field_147002_h).func_75139_a(i).func_75216_d()) {
                    int count = ((ArcFurnaceContainer)this.field_147002_h).func_75139_a(i).func_75211_c().func_190916_E();
                    if (count <= 1 || count <= largestCount) continue;
                    largestSlot = i;
                    largestCount = count;
                    continue;
                }
                if (emptySlot >= 0) continue;
                emptySlot = i;
            }
            if (emptySlot < 0 || largestSlot < 0) break;
            this.func_184098_a(((ArcFurnaceContainer)this.field_147002_h).func_75139_a(largestSlot), largestSlot, 1, ClickType.PICKUP);
            this.func_184098_a(((ArcFurnaceContainer)this.field_147002_h).func_75139_a(emptySlot), emptySlot, 0, ClickType.PICKUP);
        }
    }
}

