/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires.localhandlers;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public abstract class LocalNetworkHandler {
    private static final Map<ResourceLocation, Constructor<? extends LocalNetworkHandler>> TYPES = new HashMap<ResourceLocation, Constructor<? extends LocalNetworkHandler>>();
    protected LocalWireNetwork net;

    public static void register(ResourceLocation loc, Class<? extends LocalNetworkHandler> cl) {
        try {
            TYPES.put(loc, cl.getConstructor(LocalWireNetwork.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static LocalNetworkHandler createHandler(ResourceLocation type, LocalWireNetwork net) {
        try {
            return TYPES.get(type).newInstance(net);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected LocalNetworkHandler(LocalWireNetwork net) {
        this.net = net;
    }

    public void setLocalNet(LocalWireNetwork net) {
        this.net = net;
    }

    public abstract LocalNetworkHandler merge(LocalNetworkHandler var1);

    public abstract void onConnectorLoaded(ConnectionPoint var1, IImmersiveConnectable var2);

    public abstract void onConnectorUnloaded(BlockPos var1, IImmersiveConnectable var2);

    public abstract void onConnectorRemoved(BlockPos var1, IImmersiveConnectable var2);

    public abstract void onConnectionAdded(Connection var1);

    public abstract void onConnectionRemoved(Connection var1);
}

