/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IICProxy;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocalWireNetwork
implements IWorldTickable {
    private final GlobalWireNetwork globalNet;
    private final Map<ConnectionPoint, Collection<Connection>> connections = new HashMap<ConnectionPoint, Collection<Connection>>();
    private final Map<BlockPos, IImmersiveConnectable> connectors = new HashMap<BlockPos, IImmersiveConnectable>();
    private final Map<ResourceLocation, LocalNetworkHandler> handlers = new Object2ObjectArrayMap();
    final Object2IntMap<ResourceLocation> handlerUserCount = new Object2IntOpenHashMap();
    private List<Runnable> runNextTick = new ArrayList<Runnable>();

    public LocalWireNetwork(CompoundNBT subnet, GlobalWireNetwork globalNet) {
        this(globalNet);
        ListNBT proxies = subnet.func_150295_c("proxies", 10);
        for (INBT b : proxies) {
            IICProxy proxy = IICProxy.readFromNBT(((CompoundNBT)b).func_74775_l("proxy"));
            for (INBT p : ((CompoundNBT)b).func_150295_c("points", 10)) {
                ConnectionPoint point = new ConnectionPoint((CompoundNBT)p);
                this.loadConnector(point, proxy);
            }
        }
        ListNBT wires = subnet.func_150295_c("wires", 10);
        for (INBT b : wires) {
            Connection wire = new Connection((CompoundNBT)b);
            if (this.connectors.containsKey(wire.getEndA().getPosition()) && this.connectors.containsKey(wire.getEndB().getPosition())) {
                this.addConnection(wire);
                continue;
            }
            WireLogger.logger.error("Wire from {} to {}, but connector points are {}", (Object)wire.getEndA(), (Object)wire.getEndB(), this.connectors);
        }
    }

    public LocalWireNetwork(GlobalWireNetwork globalNet) {
        this.globalNet = globalNet;
        this.handlerUserCount.defaultReturnValue(0);
    }

    public CompoundNBT writeToNBT() {
        ListNBT wires = new ListNBT();
        for (ConnectionPoint p : this.connections.keySet()) {
            for (Connection conn : this.connections.get(p)) {
                if (!conn.isPositiveEnd(p)) continue;
                wires.add((Object)conn.toNBT());
            }
        }
        CompoundNBT ret = new CompoundNBT();
        ret.func_218657_a("wires", (INBT)wires);
        HashMultimap connsByBlock = HashMultimap.create();
        for (ConnectionPoint cp : this.connections.keySet()) {
            connsByBlock.put((Object)cp.getPosition(), (Object)cp);
        }
        ListNBT proxies = new ListNBT();
        for (BlockPos p : this.connectors.keySet()) {
            IImmersiveConnectable iic = this.connectors.get(p);
            IICProxy proxy = null;
            if (iic instanceof IICProxy) {
                proxy = (IICProxy)iic;
            } else if (iic instanceof TileEntity) {
                proxy = new IICProxy((TileEntity)iic);
            }
            if (proxy == null) continue;
            CompoundNBT complete = new CompoundNBT();
            complete.func_218657_a("proxy", (INBT)proxy.writeToNBT());
            ListNBT cps = new ListNBT();
            for (ConnectionPoint cp : connsByBlock.get((Object)p)) {
                cps.add((Object)cp.createTag());
            }
            complete.func_218657_a("points", (INBT)cps);
            proxies.add((Object)complete);
        }
        ret.func_218657_a("proxies", (INBT)proxies);
        return ret;
    }

    public Collection<BlockPos> getConnectors() {
        return Collections.unmodifiableCollection(this.connectors.keySet());
    }

    public IImmersiveConnectable getConnector(BlockPos pos) {
        assert (this.connectors.containsKey(pos));
        return this.connectors.get(pos);
    }

    public Collection<Connection> getConnections(BlockPos at) {
        return this.getConnections(new ConnectionPoint(at, 0));
    }

    public Collection<Connection> getConnections(ConnectionPoint at) {
        Collection<Connection> conns = this.connections.get(at);
        if (conns != null) {
            return Collections.unmodifiableCollection(conns);
        }
        return ImmutableSet.of();
    }

    void loadConnector(ConnectionPoint p, IImmersiveConnectable iic) {
        this.connectors.put(p.getPosition(), iic);
        this.addRequestedHandlers(iic);
        if (!this.connections.containsKey(p)) {
            this.connections.put(p, new ArrayList());
        }
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorLoaded(p, iic);
        }
    }

    private void addRequestedHandlers(ILocalHandlerProvider provider) {
        for (ResourceLocation loc : provider.getRequestedHandlers()) {
            this.handlerUserCount.put((Object)loc, this.handlerUserCount.getInt((Object)loc) + 1);
            if (!this.handlers.containsKey(loc)) {
                this.handlers.put(loc, LocalNetworkHandler.createHandler(loc, this));
            }
            WireLogger.logger.info("Increasing {} to {}", (Object)loc, (Object)this.handlerUserCount.getInt((Object)loc));
        }
    }

    void unloadConnector(BlockPos p, IImmersiveConnectable iic) {
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorUnloaded(p, iic);
        }
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(cp)) continue;
            this.removeHandlersFor(iic);
        }
        this.connectors.put(p, new IICProxy((TileEntity)iic));
    }

    LocalWireNetwork merge(LocalWireNetwork other) {
        LocalWireNetwork result = new LocalWireNetwork(this.globalNet);
        for (LocalWireNetwork net : new LocalWireNetwork[]{this, other}) {
            result.connectors.putAll(net.connectors);
            result.connections.putAll(net.connections);
        }
        result.handlers.putAll(other.handlers);
        result.handlerUserCount.putAll(other.handlerUserCount);
        for (Map.Entry entry : this.handlers.entrySet()) {
            result.handlers.merge((ResourceLocation)entry.getKey(), (LocalNetworkHandler)entry.getValue(), LocalNetworkHandler::merge);
            result.handlerUserCount.mergeInt(entry.getKey(), this.handlerUserCount.getInt(entry.getKey()), Integer::sum);
            WireLogger.logger.info("Merged {} to {}", entry.getKey(), (Object)result.handlers.get(entry.getKey()));
        }
        for (Map.Entry entry : result.handlers.entrySet()) {
            ((LocalNetworkHandler)entry.getValue()).setLocalNet(result);
        }
        return result;
    }

    void removeConnection(Connection c) {
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            boolean success = false;
            Collection<Connection> conns = this.connections.get(end);
            if (conns != null) {
                success = conns.removeIf(c::hasSameConnectors);
            }
            if (success) continue;
            WireLogger.logger.info("Failed to remove {} from {}", (Object)c, (Object)c.getEndB());
        }
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            IImmersiveConnectable connector = this.connectors.get(end.getPosition());
            if (connector == null) continue;
            connector.removeCable(c, end);
        }
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionRemoved(c);
        }
        this.removeHandlersFor(c.type);
    }

    void removeConnector(BlockPos p) {
        IImmersiveConnectable iic = this.connectors.get(p);
        if (iic == null) {
            for (ConnectionPoint point : this.getConnectionPoints()) {
                if (!point.getPosition().equals((Object)p)) continue;
                WireLogger.logger.info("Cancelling, but connections {} at {} still exist!", this.connections.get(point), (Object)point);
            }
            WireLogger.logger.info("Cancelled");
            return;
        }
        for (ConnectionPoint point : iic.getConnectionPoints()) {
            if (this.connections.containsKey(point)) {
                this.removeHandlersFor(iic);
            }
            for (Connection c : this.getConnections(point)) {
                ConnectionPoint other = c.getOtherEnd(point);
                Collection<Connection> connsOther = this.connections.get(other);
                if (connsOther == null) continue;
                connsOther.remove(c);
            }
            this.connections.remove(point);
        }
        this.connectors.remove(p);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorRemoved(p, iic);
        }
    }

    void addConnection(Connection conn) {
        IImmersiveConnectable connA = this.connectors.get(conn.getEndA().getPosition());
        if (connA == null) {
            throw new AssertionError(conn.getEndA().getPosition());
        }
        IImmersiveConnectable connB = this.connectors.get(conn.getEndB().getPosition());
        if (connB == null) {
            throw new AssertionError(conn.getEndB().getPosition());
        }
        this.connections.get(conn.getEndA()).add(conn);
        this.connections.get(conn.getEndB()).add(conn);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionAdded(conn);
        }
        this.addRequestedHandlers(conn.type);
        if (!(connA instanceof IICProxy) && !(connB instanceof IICProxy)) {
            this.globalNet.getCollisionData().addConnection(conn);
        }
    }

    private void removeHandlersFor(ILocalHandlerProvider iic) {
        for (ResourceLocation loc : iic.getRequestedHandlers()) {
            Preconditions.checkState((boolean)this.handlers.containsKey(loc), (Object)("Expected to find handler for " + loc + "(provided by " + iic + ")"));
            int remaining = this.handlerUserCount.getInt((Object)loc) - 1;
            this.handlerUserCount.put((Object)loc, remaining);
            WireLogger.logger.info("Decreasing {} to {}", (Object)loc, (Object)remaining);
            if (remaining > 0) continue;
            WireLogger.logger.info("Removing: {}", (Object)loc);
            this.handlers.remove(loc);
            this.handlerUserCount.removeInt((Object)loc);
        }
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.connections.keySet();
    }

    public Collection<LocalWireNetwork> split() {
        HashSet<ConnectionPoint> toVisit = new HashSet<ConnectionPoint>(this.getConnectionPoints());
        ArrayList<LocalWireNetwork> ret = new ArrayList<LocalWireNetwork>();
        while (!toVisit.isEmpty()) {
            ArrayDeque open = new ArrayDeque();
            ArrayList<ConnectionPoint> inComponent = new ArrayList<ConnectionPoint>();
            Iterator tmpIt = toVisit.iterator();
            open.add(tmpIt.next());
            tmpIt.remove();
            while (!open.isEmpty()) {
                ConnectionPoint curr = (ConnectionPoint)open.pop();
                inComponent.add(curr);
                for (Connection c : this.getConnections(curr)) {
                    ConnectionPoint otherEnd = c.getOtherEnd(curr);
                    if (!toVisit.contains(otherEnd)) continue;
                    toVisit.remove(otherEnd);
                    open.push(otherEnd);
                }
            }
            if (ret.isEmpty() && toVisit.isEmpty()) {
                ret.add(this);
                break;
            }
            LocalWireNetwork newNet = new LocalWireNetwork(this.globalNet);
            for (ConnectionPoint p : inComponent) {
                newNet.loadConnector(p, this.connectors.get(p.getPosition()));
            }
            for (ConnectionPoint p : inComponent) {
                for (Connection c : this.getConnections(p)) {
                    if (!c.isPositiveEnd(p)) continue;
                    newNet.addConnection(c);
                }
            }
            ret.add(newNet);
        }
        WireLogger.logger.info("Split net! Now {} nets: {}", (Object)ret.size(), ret);
        return ret;
    }

    public String toString() {
        return "Connectors: " + this.connectors + ", connections: " + this.connections;
    }

    public IImmersiveConnectable getConnector(ConnectionPoint cp) {
        return this.getConnector(cp.getPosition());
    }

    public GlobalWireNetwork getGlobal() {
        return this.globalNet;
    }

    @Override
    public void update(World w) {
        for (LocalNetworkHandler handler : this.handlers.values()) {
            if (!(handler instanceof IWorldTickable)) continue;
            ((IWorldTickable)((Object)handler)).update(w);
        }
        List<Runnable> toRun = this.runNextTick;
        this.runNextTick = new ArrayList<Runnable>();
        for (Runnable r : toRun) {
            r.run();
        }
    }

    @Nullable
    public <T extends LocalNetworkHandler> T getHandler(ResourceLocation name, Class<T> type) {
        LocalNetworkHandler p = this.handlers.get(name);
        if (p == null) {
            return null;
        }
        if (type.isInstance(p)) {
            return (T)p;
        }
        return null;
    }

    public Collection<LocalNetworkHandler> getAllHandlers() {
        return this.handlers.values();
    }

    public void addAsFutureTask(Runnable r) {
        this.runNextTick.add(r);
    }

    void removeCP(ConnectionPoint cp) {
        for (Connection c : this.getConnections(cp).toArray(new Connection[0])) {
            this.removeConnection(c);
        }
        this.connections.remove(cp);
        boolean hasMoreAtSameBlock = true;
        for (ConnectionPoint cp2 : this.connections.keySet()) {
            if (!cp.getPosition().equals((Object)cp2.getPosition())) continue;
            hasMoreAtSameBlock = false;
            break;
        }
        if (hasMoreAtSameBlock) {
            this.removeConnector(cp.getPosition());
        }
    }
}

