/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IICProxy;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.NetHandlerCapability;
import blusunrize.immersiveengineering.api.wires.NetworkSanitizer;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.common.IEConfig;
import blusunrize.immersiveengineering.common.util.SafeChunkUtils;
import blusunrize.immersiveengineering.common.wires.WireSyncManager;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GlobalWireNetwork
implements ITickableTileEntity {
    private Map<ConnectionPoint, LocalWireNetwork> localNets = new HashMap<ConnectionPoint, LocalWireNetwork>();
    private WireCollisionData collisionData = new WireCollisionData(this);
    private World world;
    private boolean validateNextTick = false;
    boolean validating = false;

    @Nonnull
    public static GlobalWireNetwork getNetwork(World w) {
        if (!w.getCapability(NetHandlerCapability.NET_CAPABILITY).isPresent()) {
            throw new RuntimeException("No net handler found for dimension " + w.func_201675_m().func_186058_p().getRegistryName() + ", remote: " + w.field_72995_K);
        }
        return (GlobalWireNetwork)Objects.requireNonNull(w.getCapability(NetHandlerCapability.NET_CAPABILITY).orElse(null));
    }

    public GlobalWireNetwork(World w) {
        this.world = w;
    }

    public void addConnection(Connection conn) {
        LocalWireNetwork joined;
        ConnectionPoint posA = conn.getEndA();
        ConnectionPoint posB = conn.getEndB();
        IImmersiveConnectable iicA = this.getLocalNet(posA).getConnector(posA.getPosition());
        IImmersiveConnectable iicB = this.getLocalNet(posB).getConnector(posB.getPosition());
        LocalWireNetwork netA = this.getNullableLocalNet(posA);
        LocalWireNetwork netB = this.getNullableLocalNet(posB);
        Collection<ConnectionPoint> toSet = new ArrayList<ConnectionPoint>(2);
        if (netA == null && netB == null) {
            WireLogger.logger.info("null-null");
            joined = new LocalWireNetwork(this);
            toSet.add(posA);
            toSet.add(posB);
            joined.loadConnector(posA, iicA);
            joined.loadConnector(posB, iicB);
        } else if (netA == null) {
            WireLogger.logger.info("null-non");
            toSet.add(posA);
            joined = netB;
            joined.loadConnector(posA, iicA);
        } else if (netB == null) {
            WireLogger.logger.info("non-null");
            toSet.add(posB);
            joined = netA;
            joined.loadConnector(posB, iicB);
        } else if (netA != netB) {
            WireLogger.logger.info("non-non-different: {} and {}", (Object)netA, (Object)netB);
            joined = netA.merge(netB);
            toSet = joined.getConnectionPoints();
        } else {
            WireLogger.logger.info("non-non-same");
            joined = netA;
        }
        WireLogger.logger.info("Result: {}, to set: {}", (Object)joined, toSet);
        for (ConnectionPoint p : toSet) {
            this.localNets.put(p, joined);
        }
        joined.addConnection(conn);
        WireSyncManager.onConnectionAdded(conn, this.world);
        this.validateNextTick = true;
    }

    public void removeAllConnectionsAt(IImmersiveConnectable iic, Consumer<Connection> handler) {
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            this.removeAllConnectionsAt(cp, handler);
        }
    }

    public void removeAllConnectionsAt(ConnectionPoint pos, Consumer<Connection> handler) {
        LocalWireNetwork net = this.getLocalNet(pos);
        ArrayList<Connection> conns = new ArrayList<Connection>(net.getConnections(pos));
        for (Connection conn : conns) {
            handler.accept(conn);
            this.removeConnection(conn);
        }
        this.validateNextTick = true;
    }

    public void removeConnection(Connection c) {
        LocalWireNetwork oldNet;
        if (!this.world.field_72995_K) {
            this.collisionData.removeConnection(c);
        }
        if ((oldNet = this.localNets.get(c.getEndA())) == null || oldNet.getConnector(c.getEndB()) == null) {
            return;
        }
        oldNet.removeConnection(c);
        this.splitNet(oldNet);
        WireSyncManager.onConnectionRemoved(c, this.world);
    }

    public void removeAndDropConnection(Connection c, BlockPos dropAt) {
        this.removeConnection(c);
        double dx = (double)dropAt.func_177958_n() + 0.5;
        double dy = (double)dropAt.func_177956_o() + 0.5;
        double dz = (double)dropAt.func_177952_p() + 0.5;
        if (this.world.func_82736_K().func_223586_b(GameRules.field_223603_f)) {
            this.world.func_217376_c((Entity)new ItemEntity(this.world, dx, dy, dz, c.type.getWireCoil(c)));
        }
    }

    private void splitNet(LocalWireNetwork oldNet) {
        Collection<LocalWireNetwork> newNets = oldNet.split();
        for (LocalWireNetwork net : newNets) {
            if (net == oldNet) continue;
            for (ConnectionPoint p : net.getConnectionPoints()) {
                this.localNets.put(p, net);
            }
        }
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.localNets.clear();
        ListNBT locals = nbt.func_150295_c("locals", 10);
        for (INBT b : locals) {
            CompoundNBT subnet = (CompoundNBT)b;
            LocalWireNetwork localNet = new LocalWireNetwork(subnet, this);
            WireLogger.logger.info("Loading net {}", (Object)localNet);
            for (ConnectionPoint p : localNet.getConnectionPoints()) {
                this.localNets.put(p, localNet);
            }
        }
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT ret = new CompoundNBT();
        ListNBT locals = new ListNBT();
        Set savedNets = Collections.newSetFromMap(new IdentityHashMap());
        for (LocalWireNetwork local : this.localNets.values()) {
            if (!savedNets.add(local)) continue;
            locals.add((Object)local.writeToNBT());
        }
        ret.func_218657_a("locals", (INBT)locals);
        return ret;
    }

    public LocalWireNetwork getLocalNet(BlockPos pos) {
        return this.getLocalNet(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getLocalNet(ConnectionPoint pos) {
        return this.localNets.computeIfAbsent(pos, p -> {
            LocalWireNetwork ret = new LocalWireNetwork(this);
            ret.loadConnector(pos, new IICProxy(this.world.field_73011_w.func_186058_p(), pos.getPosition()));
            return ret;
        });
    }

    public LocalWireNetwork getNullableLocalNet(BlockPos pos) {
        return this.localNets.get(new ConnectionPoint(pos, 0));
    }

    public LocalWireNetwork getNullableLocalNet(ConnectionPoint pos) {
        return this.localNets.get(pos);
    }

    public void removeConnector(IImmersiveConnectable iic) {
        WireLogger.logger.info("Removing {}", (Object)iic);
        ObjectArraySet netsToRemoveFrom = new ObjectArraySet();
        BlockPos iicPos = null;
        for (ConnectionPoint c : iic.getConnectionPoints()) {
            WireLogger.logger.info("Sub-point {}", (Object)c);
            LocalWireNetwork local = this.getNullableLocalNet(c);
            if (local == null) continue;
            WireLogger.logger.info("Removing");
            this.localNets.remove(c);
            netsToRemoveFrom.add(local);
            if (iicPos != null) {
                Preconditions.checkState((boolean)iicPos.equals((Object)c.getPosition()));
                continue;
            }
            iicPos = c.getPosition();
        }
        for (LocalWireNetwork net : netsToRemoveFrom) {
            net.removeConnector((BlockPos)Preconditions.checkNotNull(iicPos));
            this.splitNet(net);
        }
        this.validateNextTick = true;
    }

    public void onConnectorLoad(IImmersiveConnectable iic, World w) {
        if (this.validating) {
            WireLogger.logger.error("Adding a connector during validation!");
        }
        boolean isNew = false;
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            if (this.getNullableLocalNet(connectionPoint) == null) {
                isNew = true;
            }
            LocalWireNetwork local = this.getLocalNet(connectionPoint);
            local.loadConnector(connectionPoint, iic);
        }
        if (isNew && !this.world.field_72995_K) {
            for (Connection connection : iic.getInternalConnections()) {
                Preconditions.checkArgument((boolean)connection.isInternal(), (Object)("Internal connection for " + iic + "was not marked as internal!"));
                this.addConnection(connection);
            }
        }
        ApiUtils.addFutureServerTask(w, () -> {
            for (ConnectionPoint cp : iic.getConnectionPoints()) {
                for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                    IImmersiveConnectable iicEnd;
                    ConnectionPoint otherEnd = c.getOtherEnd(cp);
                    LocalWireNetwork otherLocal = this.getNullableLocalNet(otherEnd);
                    if (otherLocal == null || (iicEnd = otherLocal.getConnector(otherEnd)) instanceof IICProxy) continue;
                    c.generateCatenaryData(w);
                    if (w.field_72995_K) continue;
                    WireLogger.logger.info("Here: {}, other end: {}", (Object)iic, (Object)iicEnd);
                    this.collisionData.addConnection(c);
                }
            }
        }, true);
        this.validateNextTick = true;
        if (this.world.field_72995_K) {
            for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
                LocalWireNetwork localNet = this.getLocalNet(connectionPoint);
                for (Connection c : this.getLocalNet(connectionPoint).getConnections(connectionPoint)) {
                    ConnectionPoint otherEnd = c.getOtherEnd(connectionPoint);
                    IImmersiveConnectable otherIIC = localNet.getConnector(otherEnd);
                    if (otherIIC instanceof TileEntity) {
                        ((TileEntity)otherIIC).requestModelDataUpdate();
                    }
                    BlockState state = this.world.func_180495_p(otherEnd.getPosition());
                    this.world.func_184138_a(otherEnd.getPosition(), state, state, 3);
                }
                BlockState state = this.world.func_180495_p(connectionPoint.getPosition());
                this.world.func_184138_a(connectionPoint.getPosition(), state, state, 3);
            }
            if (iic instanceof TileEntity) {
                ((TileEntity)iic).requestModelDataUpdate();
            }
        }
    }

    public void onConnectorUnload(BlockPos pos, IImmersiveConnectable iic) {
        HashSet<LocalWireNetwork> added = new HashSet<LocalWireNetwork>();
        for (ConnectionPoint connectionPoint : iic.getConnectionPoints()) {
            LocalWireNetwork local = this.getLocalNet(connectionPoint);
            if (!added.add(local)) continue;
            local.unloadConnector(pos, iic);
        }
        if (!this.world.field_72995_K) {
            for (ConnectionPoint cp : iic.getConnectionPoints()) {
                for (Connection c : this.getLocalNet(cp).getConnections(cp)) {
                    this.collisionData.removeConnection(c);
                }
            }
        }
        this.validateNextTick = true;
    }

    public void func_73660_a() {
        if (this.validateNextTick) {
            this.validate();
            this.validateNextTick = false;
        }
        HashSet<LocalWireNetwork> ticked = new HashSet<LocalWireNetwork>();
        for (LocalWireNetwork net : this.localNets.values()) {
            if (!ticked.add(net)) continue;
            net.update(this.world);
        }
        if (((Boolean)IEConfig.WIRES.sanitizeConnections.get()).booleanValue()) {
            NetworkSanitizer.tick((IWorld)this.world, this);
        }
    }

    private void validate() {
        if (this.world.field_72995_K || !((Boolean)IEConfig.WIRES.enableWireLogger.get()).booleanValue()) {
            WireLogger.logger.info("Skipping validation!");
            return;
        }
        WireLogger.logger.info("Validating wire network...");
        if (this.validating) {
            WireLogger.logger.error("Recursive validation call!");
            Thread.dumpStack();
        }
        this.validating = true;
        this.localNets.values().stream().distinct().forEach(local -> {
            Object2IntOpenHashMap handlers = new Object2IntOpenHashMap();
            for (ConnectionPoint cp : local.getConnectionPoints()) {
                IImmersiveConnectable iic = local.getConnector(cp);
                if (!iic.getConnectionPoints().contains(cp)) {
                    WireLogger.logger.warn("Connection point {} does not exist on {}", (Object)cp, (Object)iic);
                    continue;
                }
                for (ResourceLocation rl : iic.getRequestedHandlers()) {
                    handlers.put((Object)rl, handlers.getInt((Object)rl) + 1);
                }
                if (this.localNets.get(cp) != local) {
                    WireLogger.logger.warn("{} has net {}, but is in net {}", (Object)cp, (Object)this.localNets.get(cp), local);
                    continue;
                }
                for (Connection c : local.getConnections(cp)) {
                    if (this.localNets.get(c.getOtherEnd(cp)) != local) {
                        WireLogger.logger.warn("{} is connected to {}, but nets are {} and {}", (Object)cp, (Object)c.getOtherEnd(cp), (Object)this.localNets.get(c.getOtherEnd(cp)), local);
                    } else if (!local.getConnections(c.getOtherEnd(cp)).contains(c)) {
                        WireLogger.logger.warn("Connection {} from {} to {} is a diode!", (Object)c, (Object)cp, (Object)c.getOtherEnd(cp));
                    }
                    if (!c.isPositiveEnd(cp)) continue;
                    for (ResourceLocation rl : c.type.getRequestedHandlers()) {
                        handlers.put((Object)rl, handlers.getInt((Object)rl) + 1);
                    }
                }
            }
            for (ResourceLocation rl : handlers.keySet()) {
                int actualCount;
                int countInNet = local.handlerUserCount.getInt((Object)rl);
                if (countInNet == (actualCount = handlers.getInt((Object)rl))) continue;
                WireLogger.logger.warn("Expected to find {} users of {}, but found {}", (Object)countInNet, (Object)rl, (Object)actualCount);
            }
            for (ResourceLocation rl : local.handlerUserCount.keySet()) {
                if (handlers.containsKey((Object)rl)) continue;
                WireLogger.logger.warn("Found no users for {}, but net expects {}", (Object)rl, (Object)local.handlerUserCount.getInt((Object)rl));
            }
            for (BlockPos p : local.getConnectors()) {
                TileEntity inWorld;
                IImmersiveConnectable inNet;
                if (!SafeChunkUtils.isChunkSafe((IWorld)this.world, p) || (inNet = local.getConnector(p)) == (inWorld = SafeChunkUtils.getSafeTE((IWorld)this.world, p))) continue;
                WireLogger.logger.warn("Connector at {}: {} in Net, {} in World (Net is {})", (Object)p, (Object)inNet, (Object)inWorld, local);
            }
        });
        WireLogger.logger.info("Validated!");
        this.validating = false;
    }

    public WireCollisionData getCollisionData() {
        return this.collisionData;
    }

    public Collection<ConnectionPoint> getAllConnectorsIn(ChunkPos pos) {
        ArrayList<ConnectionPoint> ret = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNets.keySet()) {
            if (!pos.equals((Object)new ChunkPos(cp.getPosition()))) continue;
            ret.add(cp);
        }
        return ret;
    }

    void removeCP(ConnectionPoint cp) {
        LocalWireNetwork local = this.getNullableLocalNet(cp);
        if (local != null) {
            local.removeCP(cp);
        }
    }

    public void removeConnector(BlockPos pos) {
        ArrayList<ConnectionPoint> cpsAtInvalid = new ArrayList<ConnectionPoint>();
        for (ConnectionPoint cp : this.localNets.keySet()) {
            if (!cp.getPosition().equals((Object)pos)) continue;
            cpsAtInvalid.add(cp);
        }
        for (ConnectionPoint toRemove : cpsAtInvalid) {
            this.removeCP(toRemove);
        }
    }
}

