/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Connection {
    @Nonnull
    public final WireType type;
    @Nonnull
    private final ConnectionPoint endA;
    @Nonnull
    private final ConnectionPoint endB;
    private final boolean internal;
    @Nullable
    private CatenaryData catData;
    boolean blockDataGenerated = false;

    public Connection(@Nonnull WireType type, @Nonnull ConnectionPoint endA, @Nonnull ConnectionPoint endB) {
        this.type = type;
        this.endA = endA;
        this.endB = endB;
        this.internal = false;
    }

    public Connection(BlockPos pos, int idA, int idB) {
        this.type = WireType.INTERNAL_CONNECTION;
        this.endA = new ConnectionPoint(pos, idA);
        this.endB = new ConnectionPoint(pos, idB);
        this.internal = true;
    }

    public Connection(CompoundNBT nbt) {
        this.type = WireType.getValue(nbt.func_74779_i("type"));
        this.endA = new ConnectionPoint(nbt.func_74775_l("endA"));
        this.endB = new ConnectionPoint(nbt.func_74775_l("endB"));
        this.internal = nbt.func_74767_n("internal");
    }

    public ConnectionPoint getOtherEnd(ConnectionPoint known) {
        if (known.equals(this.endA)) {
            return this.endB;
        }
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndA() {
        return this.endA;
    }

    @Nonnull
    public ConnectionPoint getEndB() {
        return this.endB;
    }

    public boolean isPositiveEnd(ConnectionPoint p) {
        return p.equals(this.endA);
    }

    public CompoundNBT toNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("endA", (INBT)this.endA.createTag());
        nbt.func_218657_a("endB", (INBT)this.endB.createTag());
        nbt.func_74778_a("type", this.type.getUniqueName());
        nbt.func_74757_a("internal", this.internal);
        return nbt;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void generateCatenaryData(World world) {
        LocalWireNetwork net = GlobalWireNetwork.getNetwork(world).getLocalNet(this.endA);
        Preconditions.checkState((net == GlobalWireNetwork.getNetwork(world).getLocalNet(this.endB) ? 1 : 0) != 0, (Object)(this.endA + " and " + this.endB + " are in different local nets?"));
        Vec3d vecA = ApiUtils.getVecForIICAt(net, this.endA, this, false);
        Vec3d vecB = ApiUtils.getVecForIICAt(net, this.endB, this, true);
        this.generateCatenaryData(vecA, vecB);
    }

    public void generateCatenaryData(Vec3d vecA, Vec3d vecB) {
        Vec3d delta = vecB.func_178788_d(vecA);
        double horLength = Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c);
        if (Math.abs(delta.field_72450_a) < 0.05 && Math.abs(delta.field_72449_c) < 0.05) {
            this.catData = new CatenaryData(true, 0.0, 0.0, 1.0, delta, 0.0, vecA);
            return;
        }
        double wireLength = delta.func_72433_c() * this.type.getSlack();
        double goal = Math.sqrt(wireLength * wireLength - delta.field_72448_b * delta.field_72448_b) / horLength;
        double lower = 0.0;
        double upper = 1.0;
        while (Math.sinh(upper) / upper < goal) {
            lower = upper;
            upper *= 2.0;
        }
        int iterations = 20;
        for (int i = 0; i < 20; ++i) {
            double middleL = (lower + upper) / 2.0;
            double middleVal = Math.sinh(middleL) / middleL;
            if (middleVal < goal) {
                lower = middleL;
                continue;
            }
            if (middleVal > goal) {
                upper = middleL;
                continue;
            }
            upper = lower = middleL;
            break;
        }
        double l = (lower + upper) / 2.0;
        double scale = horLength / (2.0 * l);
        double offsetX = (0.0 + horLength - scale * Math.log((wireLength + delta.field_72448_b) / (wireLength - delta.field_72448_b))) * 0.5;
        double offsetY = (delta.field_72448_b + 0.0 - wireLength * Math.cosh(l) / Math.sinh(l)) * 0.5;
        this.catData = new CatenaryData(false, offsetX, offsetY, scale, delta, horLength, vecA);
    }

    public boolean hasCatenaryData() {
        return this.catData != null;
    }

    public boolean isEnd(ConnectionPoint p) {
        return p.equals(this.endA) || p.equals(this.endB);
    }

    public Vec3d getPoint(double pos, ConnectionPoint from) {
        pos = this.transformPosition(pos, from);
        Vec3d basic = this.hasCatenaryData() ? this.getCatenaryData().getPoint(pos) : new Vec3d((Vec3i)this.endB.getPosition().func_177973_b((Vec3i)this.endA.getPosition())).func_186678_a(pos);
        Vec3d add = Vec3d.field_186680_a;
        if (this.endB.equals(from)) {
            add = new Vec3d((Vec3i)this.endA.getPosition().func_177973_b((Vec3i)this.endB.getPosition()));
        }
        return basic.func_178787_e(add);
    }

    public double getSlope(double pos, ConnectionPoint from) {
        if (this.hasCatenaryData()) {
            pos = this.transformPosition(pos, from);
            double slope = this.getCatenaryData().getSlope(pos);
            if (this.endB.equals(from)) {
                slope *= -1.0;
            }
            return slope;
        }
        return 0.0;
    }

    public double transformPosition(double pos, ConnectionPoint from) {
        if (this.endB.equals(from)) {
            return 1.0 - pos;
        }
        return pos;
    }

    public ConnectionPoint getEndFor(BlockPos pos) {
        return this.endA.getPosition().equals((Object)pos) ? this.endA : this.endB;
    }

    @Nonnull
    public CatenaryData getCatenaryData() {
        return (CatenaryData)Preconditions.checkNotNull((Object)this.catData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connection that = (Connection)o;
        if (this.internal != that.internal) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.endA.equals(that.endA)) {
            return false;
        }
        return this.endB.equals(that.endB);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.endA.hashCode();
        result = 31 * result + this.endB.hashCode();
        result = 31 * result + (this.internal ? 1 : 0);
        return result;
    }

    public boolean hasSameConnectors(Connection other) {
        return this.endA.equals(other.endA) && this.endB.equals(other.endB) || this.endA.equals(other.endB) && this.endB.equals(other.endA);
    }

    public static class CatenaryData {
        private final boolean isVertical;
        private final double offsetX;
        private final double offsetY;
        private final double scale;
        private final Vec3d delta;
        private final double horLength;
        private final Vec3d vecA;

        public CatenaryData(boolean isVertical, double offsetX, double offsetY, double scale, Vec3d delta, double horLength, Vec3d vecA) {
            this.isVertical = isVertical;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.scale = scale;
            this.delta = delta;
            this.horLength = horLength;
            this.vecA = vecA;
        }

        public CatenaryData(CatenaryData old, boolean reverse, Vec3d otherEndAVec) {
            this.isVertical = old.isVertical;
            if (reverse) {
                this.vecA = otherEndAVec;
                this.delta = old.delta.func_186678_a(-1.0);
                this.offsetX = old.horLength - old.offsetX;
                this.offsetY = -old.scale * Math.cosh(-this.offsetX / old.scale);
            } else {
                this.vecA = old.vecA;
                this.delta = old.delta;
                this.offsetX = old.offsetX;
                this.offsetY = old.offsetY;
            }
            this.scale = old.scale;
            this.horLength = old.horLength;
        }

        public double getSlope(double pos) {
            pos = MathHelper.func_151237_a((double)pos, (double)0.0, (double)1.0);
            if (this.isVertical) {
                return Double.POSITIVE_INFINITY * Math.signum(this.getDeltaY());
            }
            return Math.sinh((pos * this.horLength - this.offsetX) / this.scale);
        }

        public Vec3d getPoint(double pos) {
            if (pos == 1.0) {
                return this.vecA.func_178787_e(this.delta);
            }
            double x = this.delta.field_72450_a * pos;
            double y = this.isVertical ? this.delta.field_72448_b * pos : this.scale * Math.cosh((this.horLength * pos - this.offsetX) / this.scale) + this.offsetY;
            double z = this.delta.field_72449_c * pos;
            return this.vecA.func_72441_c(x, y, z);
        }

        public boolean isVertical() {
            return this.isVertical;
        }

        public double getOffsetX() {
            return this.offsetX;
        }

        public double getOffsetY() {
            return this.offsetY;
        }

        public double getScale() {
            return this.scale;
        }

        public double getDeltaX() {
            return this.delta.field_72450_a;
        }

        public double getDeltaY() {
            return this.delta.field_72448_b;
        }

        public double getDeltaZ() {
            return this.delta.field_72449_c;
        }

        public double getHorLength() {
            return this.horLength;
        }

        public Vec3d getVecA() {
            return this.vecA;
        }

        public String toString() {
            return "Vertical: " + this.isVertical + ", offset: x " + this.offsetX + " y " + this.offsetY + ", Factor A: " + this.scale + ", Vector at end A: " + this.vecA + ", horizontal length: " + this.horLength + ", delta: " + this.delta.field_72450_a + ", " + this.delta.field_72448_b + ", " + this.delta.field_72449_c;
        }

        public Vec3d getDelta() {
            return this.delta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CatenaryData that = (CatenaryData)o;
            return this.isVertical == that.isVertical && Double.compare(that.offsetX, this.offsetX) == 0 && Double.compare(that.offsetY, this.offsetY) == 0 && Double.compare(that.scale, this.scale) == 0 && Double.compare(that.horLength, this.horLength) == 0 && this.delta.equals((Object)that.delta) && this.vecA.equals((Object)that.vecA);
        }

        public int hashCode() {
            return Objects.hash(this.isVertical, this.offsetX, this.offsetY, this.scale, this.delta, this.horLength, this.vecA);
        }
    }

    public static class RenderData {
        public static final int POINTS_PER_WIRE = 16;
        public final CatenaryData data;
        public final WireType type;
        public final int pointsToRender;
        public final int color;

        public RenderData(Connection conn, boolean startAtB, int count) {
            this.type = conn.type;
            assert (conn.hasCatenaryData());
            this.pointsToRender = count;
            this.color = this.type.getColour(conn);
            this.data = new CatenaryData(conn.getCatenaryData(), startAtB, conn.getPoint(0.0, conn.getEndB()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenderData that = (RenderData)o;
            if (this.pointsToRender != that.pointsToRender) {
                return false;
            }
            if (!this.data.equals(that.data)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.data.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.pointsToRender;
            return result;
        }

        public Vec3d getPoint(int index) {
            return this.data.getPoint((double)index / 16.0);
        }
    }
}

