/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.IESaveData;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.fml.RegistryObject;

public class ExcavatorHandler {
    public static Map<ResourceLocation, MineralMix> mineralList = new HashMap<ResourceLocation, MineralMix>();
    public static HashMap<DimensionChunkCoords, MineralWorldInfo> mineralCache = new HashMap();
    public static int mineralVeinCapacity = 0;
    public static double mineralChance = 0.0;

    public static MineralMix getRandomMineral(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.mineral == null && info.mineralOverride == null) {
            return null;
        }
        if (mineralVeinCapacity >= 0 && info.depletion > mineralVeinCapacity) {
            return null;
        }
        return info.mineralOverride != null ? info.mineralOverride : info.mineral;
    }

    public static MineralWorldInfo getMineralWorldInfo(World world, int chunkX, int chunkZ) {
        return ExcavatorHandler.getMineralWorldInfo(world, new DimensionChunkCoords(world.func_201675_m().func_186058_p(), chunkX, chunkZ), false);
    }

    public static MineralWorldInfo getMineralWorldInfo(World world, DimensionChunkCoords chunkCoords, boolean guaranteed) {
        if (world.field_72995_K) {
            return null;
        }
        MineralWorldInfo worldInfo = mineralCache.get((Object)chunkCoords);
        if (worldInfo == null) {
            MineralSelection selection;
            boolean empty;
            MineralMix mix = null;
            Random r = SharedSeedRandom.func_205190_a((int)chunkCoords.field_77276_a, (int)chunkCoords.field_77275_b, (long)world.func_72905_C(), (long)940610990913L);
            double dd = r.nextDouble();
            boolean bl = empty = !guaranteed && dd > mineralChance;
            if (!empty && (selection = new MineralSelection(chunkCoords, 2)).getTotalWeight() > 0) {
                int weight = selection.getRandomWeight(r);
                for (MineralMix e : selection.getMinerals()) {
                    if ((weight -= e.weight) >= 0) continue;
                    mix = e;
                    break;
                }
            }
            worldInfo = new MineralWorldInfo();
            worldInfo.mineral = mix;
            mineralCache.put(chunkCoords, worldInfo);
            IESaveData.setDirty();
        }
        return worldInfo;
    }

    public static void depleteMinerals(World world, int chunkX, int chunkZ) {
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        ++info.depletion;
        IESaveData.setDirty();
    }

    public static class MineralSelection {
        private final int totalWeight;
        private final Set<MineralMix> validMinerals;

        public MineralSelection(DimensionChunkCoords chunkCoords, int radius) {
            HashSet<MineralMix> surrounding = new HashSet<MineralMix>();
            for (int xx = -radius; xx <= radius; ++xx) {
                for (int zz = -radius; zz <= radius; ++zz) {
                    DimensionChunkCoords offset;
                    MineralWorldInfo worldInfo;
                    if (xx == 0 && zz == 0 || (worldInfo = mineralCache.get((Object)(offset = chunkCoords.withOffset(xx, zz)))) == null || worldInfo.mineral == null) continue;
                    surrounding.add(worldInfo.mineral);
                }
            }
            int weight = 0;
            this.validMinerals = new HashSet<MineralMix>();
            for (MineralMix e : mineralList.values()) {
                if (!e.validDimension(chunkCoords.dimension) || surrounding.contains(e)) continue;
                this.validMinerals.add(e);
                weight += e.weight;
            }
            this.totalWeight = weight;
        }

        public int getTotalWeight() {
            return this.totalWeight;
        }

        public int getRandomWeight(Random random) {
            return Math.abs(random.nextInt() % this.totalWeight);
        }

        public Set<MineralMix> getMinerals() {
            return this.validMinerals;
        }
    }

    public static class MineralWorldInfo {
        public MineralMix mineral;
        public MineralMix mineralOverride;
        public int depletion;

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            if (this.mineral != null) {
                tag.func_74778_a("mineral", this.mineral.func_199560_c().toString());
            }
            if (this.mineralOverride != null) {
                tag.func_74778_a("mineralOverride", this.mineralOverride.func_199560_c().toString());
            }
            tag.func_74768_a("depletion", this.depletion);
            return tag;
        }

        public static MineralWorldInfo readFromNBT(CompoundNBT tag) {
            ResourceLocation id;
            MineralWorldInfo info = new MineralWorldInfo();
            if (tag.func_74764_b("mineral")) {
                id = new ResourceLocation(tag.func_74779_i("mineral"));
                info.mineral = mineralList.get(id);
            }
            if (tag.func_74764_b("mineralOverride")) {
                id = new ResourceLocation(tag.func_74779_i("mineralOverride"));
                info.mineralOverride = mineralList.get(id);
            }
            info.depletion = tag.func_74762_e("depletion");
            return info;
        }
    }

    public static class MineralMix
    extends IESerializableRecipe {
        public static IRecipeType<MineralMix> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:mineral_mix");
        public static RegistryObject<IERecipeSerializer<MineralMix>> SERIALIZER;
        public final StackWithChance[] outputs;
        public final int weight;
        public final float failChance;
        public final ImmutableSet<DimensionType> dimensions;
        public final Block background;

        public MineralMix(ResourceLocation id, StackWithChance[] outputs, int weight, float failChance, DimensionType[] dimensions, Block background) {
            super(ItemStack.field_190927_a, TYPE, id);
            this.weight = weight;
            this.failChance = failChance;
            this.outputs = outputs;
            this.dimensions = ImmutableSet.copyOf((Object[])dimensions);
            this.background = background;
        }

        @Override
        protected IERecipeSerializer<MineralMix> getIESerializer() {
            return (IERecipeSerializer)SERIALIZER.get();
        }

        public ItemStack func_77571_b() {
            return ItemStack.field_190927_a;
        }

        public String getPlainName() {
            String path = this.func_199560_c().func_110623_a();
            return path.substring(path.lastIndexOf("/") + 1);
        }

        public String getTranslationKey() {
            return "desc.immersiveengineering.info.mineral." + this.getPlainName();
        }

        public ItemStack getRandomOre(Random rand) {
            float r = rand.nextFloat();
            for (StackWithChance o : this.outputs) {
                if (!(o.getChance() >= 0.0f) || !((r -= o.getChance()) < 0.0f)) continue;
                return o.getStack();
            }
            return ItemStack.field_190927_a;
        }

        public boolean validDimension(DimensionType dim) {
            if (this.dimensions != null && !this.dimensions.isEmpty()) {
                return this.dimensions.contains((Object)dim);
            }
            return true;
        }
    }
}

