/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerHandler {
    public static HashMap<ResourceLocation, ChemthrowerEffect> effectMap = new HashMap();
    public static HashSet<ResourceLocation> flammableList = new HashSet();
    public static HashSet<ResourceLocation> gasList = new HashSet();

    public static void registerEffect(Fluid fluid, ChemthrowerEffect effect) {
        if (fluid != null) {
            ChemthrowerHandler.registerEffect(fluid.getRegistryName(), effect);
        }
    }

    public static void registerEffect(ResourceLocation fluidName, ChemthrowerEffect effect) {
        effectMap.put(fluidName, effect);
    }

    public static ChemthrowerEffect getEffect(Fluid fluid) {
        if (fluid != null) {
            return ChemthrowerHandler.getEffect(fluid.getRegistryName());
        }
        return null;
    }

    public static ChemthrowerEffect getEffect(ResourceLocation fluidName) {
        return effectMap.get(fluidName);
    }

    public static void registerFlammable(Fluid fluid) {
        if (fluid != null) {
            ChemthrowerHandler.registerFlammable(fluid.getRegistryName());
        }
    }

    public static void registerFlammable(ResourceLocation fluidName) {
        flammableList.add(fluidName);
    }

    public static boolean isFlammable(Fluid fluid) {
        if (fluid != null) {
            return flammableList.contains(fluid.getRegistryName());
        }
        return false;
    }

    public static boolean isFlammable(ResourceLocation fluidName) {
        return flammableList.contains(fluidName);
    }

    public static void registerGas(Fluid fluid) {
        if (fluid != null) {
            ChemthrowerHandler.registerGas(fluid.getRegistryName());
        }
    }

    public static void registerGas(ResourceLocation fluidName) {
        gasList.add(fluidName);
    }

    public static boolean isGas(Fluid fluid) {
        if (fluid != null) {
            return gasList.contains(fluid.getRegistryName());
        }
        return false;
    }

    public static boolean isGas(ResourceLocation fluidName) {
        return gasList.contains(fluidName);
    }

    public static class ChemthrowerEffect_RandomTeleport
    extends ChemthrowerEffect_Damage {
        float chance;

        public ChemthrowerEffect_RandomTeleport(DamageSource source, float damage, float chance) {
            super(source, damage);
            this.chance = chance;
        }

        @Override
        public void applyToEntity(LivingEntity target, PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            double z;
            double y;
            double x;
            super.applyToEntity(target, shooter, thrower, fluid);
            if (Utils.RAND.nextFloat() < this.chance && !target.field_70170_p.func_180495_p(new BlockPos(x = target.func_226277_ct_() - 8.0 + (double)Utils.RAND.nextInt(17), y = target.func_226278_cu_() + (double)Utils.RAND.nextInt(8), z = target.func_226281_cx_() - 8.0 + (double)Utils.RAND.nextInt(17))).func_185904_a().func_76220_a()) {
                EnderTeleportEvent event = new EnderTeleportEvent(target, x, y, z, 0.0f);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return;
                }
                target.func_70634_a(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                target.field_70170_p.func_184134_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
            }
        }
    }

    public static class ChemthrowerEffect_Extinguish
    extends ChemthrowerEffect {
        private static DamageSource getPlayerDrownDamage(PlayerEntity player) {
            if (player == null) {
                return DamageSource.field_76369_e;
            }
            return new EntityDamageSource(DamageSource.field_76369_e.func_76355_l(), (Entity)player).func_76348_h();
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if ((target instanceof BlazeEntity || target instanceof EndermanEntity) && target.func_70097_a(ChemthrowerEffect_Extinguish.getPlayerDrownDamage(shooter), 3.0f)) {
                target.field_70172_ad = (int)((double)target.field_70172_ad * 0.75);
            }
        }

        @Override
        public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            if (!(mop instanceof BlockRayTraceResult)) {
                return;
            }
            BlockRayTraceResult rtr = (BlockRayTraceResult)mop;
            Block b = world.func_180495_p(rtr.func_216350_a().func_177972_a(rtr.func_216354_b())).func_177230_c();
            if (b instanceof FireBlock) {
                world.func_217377_a(rtr.func_216350_a().func_177972_a(rtr.func_216354_b()), false);
            }
        }
    }

    public static class ChemthrowerEffect_Potion
    extends ChemthrowerEffect_Damage {
        EffectInstance[] potionEffects;
        float[] effectChances;

        public ChemthrowerEffect_Potion(DamageSource source, float damage, EffectInstance ... effects) {
            super(source, damage);
            this.potionEffects = effects;
            this.effectChances = new float[this.potionEffects.length];
            for (int i = 0; i < this.effectChances.length; ++i) {
                this.effectChances[i] = 1.0f;
            }
        }

        public ChemthrowerEffect_Potion(DamageSource source, float damage, Effect potion, int duration, int amplifier) {
            this(source, damage, new EffectInstance(potion, duration, amplifier));
        }

        public ChemthrowerEffect_Potion setEffectChance(int effectIndex, float chance) {
            if (effectIndex >= 0 && effectIndex < this.effectChances.length) {
                this.effectChances[effectIndex] = chance;
            }
            return this;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (this.potionEffects != null && this.potionEffects.length > 0) {
                for (int iEffect = 0; iEffect < this.potionEffects.length; ++iEffect) {
                    if (!(target.func_70681_au().nextFloat() < this.effectChances[iEffect])) continue;
                    EffectInstance e = this.potionEffects[iEffect];
                    EffectInstance newEffect = new EffectInstance(e.func_188419_a(), e.func_76459_b(), e.func_76458_c());
                    newEffect.setCurativeItems(new ArrayList(e.getCurativeItems()));
                    target.func_195064_c(newEffect);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Damage
    extends ChemthrowerEffect {
        DamageSource source;
        float damage;

        public ChemthrowerEffect_Damage(DamageSource source, float damage) {
            this.source = source;
            this.damage = damage;
        }

        @Override
        public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            if (this.source != null && target.func_70097_a(this.source, this.damage)) {
                target.field_70172_ad = (int)((double)target.field_70172_ad * 0.75);
                if (this.source.func_76347_k() && !target.func_70045_F()) {
                    target.func_70015_d(fluid.getAttributes().isGaseous() ? 2 : 5);
                }
            }
        }

        @Override
        public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
        }
    }

    public static abstract class ChemthrowerEffect {
        public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToEntity(target, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToEntity(LivingEntity var1, @Nullable PlayerEntity var2, ItemStack var3, Fluid var4);

        public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
            this.applyToBlock(world, mop, shooter, thrower, fluid.getFluid());
        }

        public abstract void applyToBlock(World var1, RayTraceResult var2, @Nullable PlayerEntity var3, ItemStack var4, Fluid var5);
    }
}

