/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShaderLayer {
    private final ResourceLocation texture;
    private final int color;
    private double[] textureBounds;
    private double[] cutoutBounds;

    public ShaderLayer(ResourceLocation texture, int color) {
        this.texture = texture;
        this.color = color;
        if (ShaderRegistry.defaultLayerBounds.containsKey(texture)) {
            this.setTextureBounds(ShaderRegistry.defaultLayerBounds.get(texture));
        }
    }

    public ShaderLayer setTextureBounds(double ... bounds) {
        if (bounds == null) {
            return this;
        }
        Preconditions.checkArgument((bounds.length == 4 ? 1 : 0) != 0);
        this.textureBounds = bounds;
        return this;
    }

    public double[] getTextureBounds() {
        return this.textureBounds;
    }

    public ShaderLayer setCutoutBounds(double ... bounds) {
        if (bounds == null) {
            return this;
        }
        Preconditions.checkArgument((bounds.length == 4 ? 1 : 0) != 0);
        this.cutoutBounds = bounds;
        return this;
    }

    public double[] getCutoutBounds() {
        return this.cutoutBounds;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector4f getColor() {
        return new Vector4f((float)(this.color >> 16 & 0xFF) / 255.0f, (float)(this.color >> 8 & 0xFF) / 255.0f, (float)(this.color & 0xFF) / 255.0f, (float)(this.color >> 24 & 0xFF) / 255.0f);
    }

    public boolean isDynamicLayer() {
        return false;
    }

    public RenderType getRenderType(RenderType baseType) {
        return baseType;
    }

    public boolean isTranslucent() {
        return false;
    }
}

