/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CapabilityShader {
    @CapabilityInject(value=ShaderWrapper.class)
    public static Capability<ShaderWrapper> SHADER_CAPABILITY = null;
    public static ModelProperty<ShaderWrapper> MODEL_PROPERTY = new ModelProperty();

    public static void register() {
        CapabilityManager.INSTANCE.register(ShaderWrapper.class, (Capability.IStorage)new Capability.IStorage<ShaderWrapper>(){

            public INBT writeNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, Direction side) {
                CompoundNBT nbt = new CompoundNBT();
                ItemStack shader = instance.getShaderItem();
                if (!shader.func_190926_b()) {
                    shader.func_77955_b(nbt);
                } else {
                    nbt.func_74778_a("IE:NoShader", "");
                }
                nbt.func_74778_a("IE:ShaderType", instance.getShaderType().toString());
                return nbt;
            }

            public void readNBT(Capability<ShaderWrapper> capability, ShaderWrapper instance, Direction side, INBT nbt) {
                CompoundNBT tags = (CompoundNBT)nbt;
                instance.setShaderType(new ResourceLocation(tags.func_74779_i("IE:ShaderType")));
                if (!tags.func_74764_b("IE:NoShader")) {
                    instance.setShaderItem(ItemStack.func_199557_a((CompoundNBT)tags));
                }
            }
        }, (Callable)new Callable<ShaderWrapper>(){

            @Override
            public ShaderWrapper call() {
                return new ShaderWrapper_Direct(new ResourceLocation(""));
            }
        });
    }

    public static class ShaderWrapper_Direct
    extends ShaderWrapper
    implements ICapabilityProvider,
    INBTSerializable<CompoundNBT> {
        @Nonnull
        protected ItemStack shader = ItemStack.field_190927_a;
        private LazyOptional<ShaderWrapper> opt = ApiUtils.constantOptional(this);

        public ShaderWrapper_Direct(ResourceLocation type) {
            super(type);
        }

        @Override
        public void setShaderItem(@Nonnull ItemStack shader) {
            this.shader = shader;
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            return this.shader;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == SHADER_CAPABILITY) {
                return this.opt.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundNBT serializeNBT() {
            CompoundNBT nbt = new CompoundNBT();
            ItemStack shader = this.getShaderItem();
            if (!shader.func_190926_b()) {
                shader.func_77955_b(nbt);
            } else {
                nbt.func_74778_a("IE:NoShader", "");
            }
            nbt.func_74778_a("IE:ShaderType", this.getShaderType().toString());
            return nbt;
        }

        public void deserializeNBT(CompoundNBT nbt) {
            CompoundNBT tags = nbt;
            this.setShaderType(new ResourceLocation(tags.func_74779_i("IE:ShaderType")));
            if (!tags.func_74764_b("IE:NoShader")) {
                this.setShaderItem(ItemStack.func_199557_a((CompoundNBT)tags));
            }
        }
    }

    public static class ShaderWrapper_Item
    extends ShaderWrapper {
        public static final String SHADER_NBT_KEY = "IE:Shader";
        protected final ItemStack container;

        public ShaderWrapper_Item(ResourceLocation type, ItemStack container) {
            super(type);
            this.container = container;
        }

        @Override
        public void setShaderItem(ItemStack shader) {
            if (!this.container.func_77942_o()) {
                this.container.func_77982_d(new CompoundNBT());
            }
            if (!shader.func_190926_b()) {
                CompoundNBT shaderTag = shader.func_77955_b(new CompoundNBT());
                this.container.func_196082_o().func_218657_a(SHADER_NBT_KEY, (INBT)shaderTag);
            } else {
                this.container.func_196082_o().func_82580_o(SHADER_NBT_KEY);
            }
        }

        @Override
        @Nonnull
        public ItemStack getShaderItem() {
            if (!this.container.func_77942_o()) {
                return ItemStack.field_190927_a;
            }
            CompoundNBT tagCompound = this.container.func_196082_o();
            if (!tagCompound.func_150297_b(SHADER_NBT_KEY, 10)) {
                return ItemStack.field_190927_a;
            }
            return ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l(SHADER_NBT_KEY));
        }
    }

    public static abstract class ShaderWrapper {
        protected ResourceLocation shaderType;

        public ShaderWrapper(ResourceLocation type) {
            this.shaderType = type;
        }

        public void setShaderType(ResourceLocation shaderType) {
            this.shaderType = shaderType;
        }

        public ResourceLocation getShaderType() {
            return this.shaderType;
        }

        public abstract void setShaderItem(@Nonnull ItemStack var1);

        @Nonnull
        public abstract ItemStack getShaderItem();
    }
}

