/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IJEIRecipe;
import blusunrize.immersiveengineering.api.crafting.IMultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiblockRecipe
extends IESerializableRecipe
implements IMultiblockRecipe,
IJEIRecipe {
    private List<IngredientWithSize> inputList = new ArrayList<IngredientWithSize>(0);
    protected NonNullList<ItemStack> outputList = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    protected List<FluidStack> fluidInputList;
    protected List<FluidStack> fluidOutputList;
    int totalProcessTime;
    int totalProcessEnergy;
    public List<ItemStack>[] jeiItemInputList;
    protected List<ItemStack> jeiTotalItemInputList;
    public List<ItemStack>[] jeiItemOutputList;
    protected List<ItemStack> jeiTotalItemOutputList;
    protected List<FluidStack> jeiFluidInputList;
    protected List<FluidStack> jeiFluidOutputList;

    protected MultiblockRecipe(ItemStack outputDummy, IRecipeType<?> type, ResourceLocation id) {
        super(outputDummy, type, id);
    }

    public ItemStack func_77571_b() {
        NonNullList<ItemStack> outputs = this.getItemOutputs();
        if (outputs != null && outputs.size() > 0) {
            return (ItemStack)outputs.get(0);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public List<IngredientWithSize> getItemInputs() {
        return this.inputList;
    }

    protected void setInputListWithSizes(List<IngredientWithSize> inputList) {
        this.inputList = new ArrayList<IngredientWithSize>(inputList);
    }

    protected void setInputList(List<Ingredient> inputList) {
        this.inputList = inputList.stream().map(IngredientWithSize::new).collect(Collectors.toList());
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return this.outputList;
    }

    @Override
    public List<FluidStack> getFluidInputs() {
        return this.fluidInputList;
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return this.fluidOutputList;
    }

    @Override
    public int getTotalProcessTime() {
        return this.totalProcessTime;
    }

    @Override
    public int getTotalProcessEnergy() {
        return this.totalProcessEnergy;
    }

    public void setupJEI() {
        FluidStack fs;
        ArrayList list;
        int i;
        if (this.inputList != null) {
            this.jeiItemInputList = new ArrayList[this.inputList.size()];
            this.jeiTotalItemInputList = new ArrayList<ItemStack>();
            for (i = 0; i < this.inputList.size(); ++i) {
                IngredientWithSize ingr = this.inputList.get(i);
                this.jeiItemInputList[i] = list = Lists.newArrayList((Object[])ingr.getMatchingStacks());
                this.jeiTotalItemInputList.addAll(list);
            }
        } else {
            this.jeiTotalItemInputList = Collections.emptyList();
        }
        if (this.outputList != null) {
            this.jeiItemOutputList = new ArrayList[this.outputList.size()];
            this.jeiTotalItemOutputList = new ArrayList<ItemStack>();
            for (i = 0; i < this.outputList.size(); ++i) {
                ItemStack s = (ItemStack)this.outputList.get(i);
                this.jeiItemOutputList[i] = list = Lists.newArrayList((Object[])new ItemStack[]{!s.func_190926_b() ? s.func_77946_l() : ItemStack.field_190927_a});
                this.jeiTotalItemOutputList.addAll(list);
            }
        } else {
            this.jeiTotalItemOutputList = Collections.emptyList();
        }
        if (this.fluidInputList != null) {
            this.jeiFluidInputList = new ArrayList<FluidStack>();
            for (i = 0; i < this.fluidInputList.size(); ++i) {
                fs = this.fluidInputList.get(i);
                if (fs == null) continue;
                this.jeiFluidInputList.add(fs.copy());
            }
        } else {
            this.jeiFluidInputList = Collections.emptyList();
        }
        if (this.fluidOutputList != null) {
            this.jeiFluidOutputList = new ArrayList<FluidStack>();
            for (i = 0; i < this.fluidOutputList.size(); ++i) {
                fs = this.fluidOutputList.get(i);
                if (fs == null) continue;
                this.jeiFluidOutputList.add(fs.copy());
            }
        } else {
            this.jeiFluidOutputList = Collections.emptyList();
        }
    }

    @Override
    public List<ItemStack> getJEITotalItemInputs() {
        return this.jeiTotalItemInputList;
    }

    @Override
    public List<ItemStack> getJEITotalItemOutputs() {
        return this.jeiTotalItemOutputList;
    }

    @Override
    public List<FluidStack> getJEITotalFluidInputs() {
        return this.jeiFluidInputList;
    }

    @Override
    public List<FluidStack> getJEITotalFluidOutputs() {
        return this.jeiFluidOutputList;
    }
}

