/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;

public class CrusherRecipe
extends MultiblockRecipe {
    public static IRecipeType<CrusherRecipe> TYPE = IRecipeType.func_222147_a((String)"immersiveengineering:crusher");
    public static RegistryObject<IERecipeSerializer<CrusherRecipe>> SERIALIZER;
    public static float energyModifier;
    public static float timeModifier;
    public final Ingredient input;
    public final ItemStack output;
    public final List<StackWithChance> secondaryOutputs = new ArrayList<StackWithChance>();
    public static Map<ResourceLocation, CrusherRecipe> recipeList;

    public CrusherRecipe(ResourceLocation id, ItemStack output, Ingredient input, int energy) {
        super(output, TYPE, id);
        this.output = output;
        this.input = input;
        this.totalProcessEnergy = (int)Math.floor((float)energy * energyModifier);
        this.totalProcessTime = (int)Math.floor(50.0f * timeModifier);
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = ListUtils.fromItem(this.output);
    }

    @Override
    protected IERecipeSerializer<CrusherRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs(TileEntity tile) {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)this.output);
        for (StackWithChance output : this.secondaryOutputs) {
            if (output.getStack().func_190926_b() || !(Utils.RAND.nextFloat() < output.getChance())) continue;
            list.add((Object)output.getStack());
        }
        return list;
    }

    public CrusherRecipe addToSecondaryOutput(StackWithChance output) {
        Preconditions.checkNotNull((Object)output);
        this.secondaryOutputs.add(output);
        return this;
    }

    public static CrusherRecipe findRecipe(ItemStack input) {
        for (CrusherRecipe recipe : recipeList.values()) {
            if (!recipe.input.test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 4;
    }

    static {
        energyModifier = 1.0f;
        timeModifier = 1.0f;
    }
}

