/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IICProxy;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireCollisionData;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.CatenaryTracer;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ApiUtils {
    public static boolean compareToOreName(ItemStack stack, ResourceLocation oreName) {
        if (!ApiUtils.isNonemptyBlockOrItemTag(oreName)) {
            return false;
        }
        Tag itemTag = ItemTags.func_199903_a().func_199910_a(oreName);
        if (itemTag != null && itemTag.func_199885_a().contains(stack.func_77973_b())) {
            return true;
        }
        Tag blockTag = BlockTags.func_199896_a().func_199910_a(oreName);
        return blockTag != null && blockTag.func_199885_a().stream().map(IItemProvider::func_199767_j).anyMatch(i -> stack.func_77973_b() == i);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        return ApiUtils.stackMatchesObject(stack, o, false);
    }

    public static boolean stackMatchesObject(ItemStack stack, Object o, boolean checkNBT) {
        if (o instanceof ItemStack) {
            return ItemStack.func_179545_c((ItemStack)((ItemStack)o), (ItemStack)stack) && (!checkNBT || Utils.compareItemNBT((ItemStack)o, stack));
        }
        if (o instanceof Collection) {
            for (Object io : (Collection)o) {
                if (!ApiUtils.stackMatchesObject(stack, io, checkNBT)) continue;
                return true;
            }
        } else {
            if (o instanceof IngredientWithSize) {
                return ((IngredientWithSize)o).test(stack);
            }
            if (o instanceof Ingredient) {
                return ((Ingredient)o).test(stack);
            }
            if (o instanceof ItemStack[]) {
                for (ItemStack io : (ItemStack[])o) {
                    if (!ItemStack.func_179545_c((ItemStack)io, (ItemStack)stack) || checkNBT && !Utils.compareItemNBT(io, stack)) continue;
                    return true;
                }
            } else {
                if (o instanceof FluidStack) {
                    return (Boolean)FluidUtil.getFluidContained((ItemStack)stack).map(fs -> fs.containsFluid((FluidStack)o)).orElse((Object)false);
                }
                if (o instanceof ResourceLocation) {
                    return ApiUtils.compareToOreName(stack, (ResourceLocation)o);
                }
                if (o instanceof IngredientWithSize) {
                    return ((IngredientWithSize)o).test(stack);
                }
                throw new IllegalArgumentException("Comparisong object " + o + " of class " + o.getClass() + " is invalid!");
            }
        }
        return false;
    }

    public static ItemStack copyStackWithAmount(ItemStack stack, int amount) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack s2 = stack.func_77946_l();
        s2.func_190920_e(amount);
        return s2;
    }

    public static boolean stacksMatchIngredientList(List<Ingredient> list, NonNullList<ItemStack> stacks) {
        return ApiUtils.stacksMatchList(list, stacks, i -> 1, Ingredient::test);
    }

    public static boolean stacksMatchIngredientWithSizeList(List<IngredientWithSize> list, NonNullList<ItemStack> stacks) {
        return ApiUtils.stacksMatchList(list, stacks, IngredientWithSize::getCount, IngredientWithSize::testIgnoringSize);
    }

    private static <T> boolean stacksMatchList(List<T> list, NonNullList<ItemStack> stacks, Function<T, Integer> size, BiPredicate<T, ItemStack> matchesIgnoringSize) {
        ArrayList<ItemStack> queryList = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack s : stacks) {
            if (s.func_190926_b()) continue;
            queryList.add(s.func_77946_l());
        }
        for (T ingr : list) {
            if (ingr == null) continue;
            int amount = size.apply(ingr);
            Iterator it = queryList.iterator();
            while (it.hasNext()) {
                ItemStack query = (ItemStack)it.next();
                if (query.func_190926_b()) continue;
                if (matchesIgnoringSize.test(ingr, query)) {
                    if (query.func_190916_E() > amount) {
                        query.func_190918_g(amount);
                        amount = 0;
                    } else {
                        amount -= query.func_190916_E();
                        query.func_190920_e(0);
                    }
                }
                if (query.func_190916_E() <= 0) {
                    it.remove();
                }
                if (amount > 0) continue;
                break;
            }
            if (amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static Ingredient createIngredientFromList(List<ItemStack> list) {
        return Ingredient.func_193369_a((ItemStack[])list.toArray(new ItemStack[0]));
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy) {
        return ApiUtils.createComparableItemStack(stack, copy, stack.func_77942_o() && !stack.func_196082_o().isEmpty());
    }

    public static ComparableItemStack createComparableItemStack(ItemStack stack, boolean copy, boolean useNbt) {
        ComparableItemStack comp = new ComparableItemStack(stack, copy);
        comp.setUseNBT(useNbt);
        return comp;
    }

    public static JsonElement jsonSerializeFluidStack(FluidStack fluidStack) {
        if (fluidStack == null) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("fluid", fluidStack.getFluid().getRegistryName().toString());
        jsonObject.addProperty("amount", (Number)fluidStack.getAmount());
        if (fluidStack.hasTag()) {
            jsonObject.addProperty("tag", fluidStack.getTag().toString());
        }
        return jsonObject;
    }

    public static FluidStack jsonDeserializeFluidStack(JsonObject jsonObject) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"fluid")));
        int amount = JSONUtils.func_151203_m((JsonObject)jsonObject, (String)"amount");
        FluidStack fluidStack = new FluidStack(fluid, amount);
        if (JSONUtils.func_151204_g((JsonObject)jsonObject, (String)"tag")) {
            fluidStack.setTag(JsonUtils.readNBT((JsonObject)jsonObject, (String)"tag"));
        }
        return fluidStack;
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        Tag t = (Tag)ItemTags.func_199903_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        Tag t = (Tag)BlockTags.func_199896_a().func_200039_c().get(name);
        return t != null && !t.func_199885_a().isEmpty();
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return ApiUtils.isNonemptyBlockTag(name) || ApiUtils.isNonemptyItemTag(name);
    }

    public static NonNullList<ItemStack> getItemsInTag(ResourceLocation name) {
        NonNullList ret = NonNullList.func_191196_a();
        ApiUtils.addItemsInTag((NonNullList<ItemStack>)ret, ItemTags.func_199903_a().func_199910_a(name));
        ApiUtils.addItemsInTag((NonNullList<ItemStack>)ret, BlockTags.func_199896_a().func_199910_a(name));
        return ret;
    }

    private static <T extends IItemProvider> void addItemsInTag(NonNullList<ItemStack> out, Tag<T> in) {
        if (in != null) {
            in.func_199885_a().stream().map(ItemStack::new).forEach(arg_0 -> out.add(arg_0));
        }
    }

    public static boolean isMetalComponent(ItemStack stack, String componentType) {
        return ApiUtils.getMetalComponentType(stack, componentType) != null;
    }

    public static String getMetalComponentType(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : ApiUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                return componentType;
            }
        }
        return null;
    }

    public static Collection<ResourceLocation> getMatchingTagNames(ItemStack stack) {
        HashSet<ResourceLocation> ret = new HashSet<ResourceLocation>(stack.func_77973_b().getTags());
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        if (b != Blocks.field_150350_a) {
            ret.addAll(b.getTags());
        }
        return ret;
    }

    public static String[] getMetalComponentTypeAndMetal(ItemStack stack, String ... componentTypes) {
        for (ResourceLocation name : ApiUtils.getMatchingTagNames(stack)) {
            for (String componentType : componentTypes) {
                if (!name.func_110623_a().startsWith(componentType)) continue;
                String material = name.func_110623_a().substring(componentType.length());
                if (material.startsWith("/")) {
                    material = material.substring(1);
                }
                if (material.length() <= 0) continue;
                return new String[]{componentType, material};
            }
        }
        return null;
    }

    public static boolean isIngot(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "ingots/");
    }

    public static boolean isPlate(ItemStack stack) {
        return ApiUtils.isMetalComponent(stack, "plates/");
    }

    public static int getComponentIngotWorth(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String key = ApiUtils.getMetalComponentType(stack, keys);
        if (key != null && (relation = IEApi.prefixToIngotMap.get(key)) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return (int)val;
        }
        return 0;
    }

    public static ItemStack breakStackIntoIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return ApiUtils.copyStackWithAmount(IEApi.getPreferredTagStack(IETags.getIngot(type[1])), (int)val);
        }
        return ItemStack.field_190927_a;
    }

    public static Pair<ItemStack, Double> breakStackIntoPreciseIngots(ItemStack stack) {
        Integer[] relation;
        String[] keys = IEApi.prefixToIngotMap.keySet().toArray(new String[0]);
        String[] type = ApiUtils.getMetalComponentTypeAndMetal(stack, keys);
        if (type != null && (relation = IEApi.prefixToIngotMap.get(type[0])) != null && relation.length > 1) {
            double val = (double)relation[0].intValue() / (double)relation[1].intValue();
            return new ImmutablePair((Object)IEApi.getPreferredTagStack(IETags.getIngot(type[1])), (Object)val);
        }
        return null;
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos) && !(list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart)).isEmpty() && (cap = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return (Boolean)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
            }).orElse((Object)false);
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return (ItemStack)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                    return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                }
                return stack;
            }).orElse((Object)stack);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side, boolean simulate) {
        if (inventory != null && !stack.func_190926_b()) {
            return (ItemStack)inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate)).orElse((Object)stack);
        }
        return stack;
    }

    public static BlockPos toBlockPos(Object object) {
        if (object instanceof BlockPos) {
            return (BlockPos)object;
        }
        if (object instanceof TileEntity) {
            return ((TileEntity)object).func_174877_v();
        }
        if (object instanceof IICProxy) {
            return ((IICProxy)object).getPos();
        }
        return null;
    }

    @Deprecated
    public static IImmersiveConnectable toIIC(Object object, World world) {
        return ApiUtils.toIIC(object, world, true);
    }

    @Deprecated
    public static IImmersiveConnectable toIIC(Object object, World world, boolean allowProxies) {
        if (object instanceof IImmersiveConnectable) {
            return (IImmersiveConnectable)object;
        }
        if (object instanceof BlockPos) {
            BlockPos pos = (BlockPos)object;
            if (world != null && (allowProxies || world.func_175667_e(pos))) {
                return GlobalWireNetwork.getNetwork(world).getLocalNet(pos).getConnector(pos);
            }
        }
        return null;
    }

    public static Vec3d getVecForIICAt(LocalWireNetwork net, ConnectionPoint pos, Connection conn, boolean fromOtherEnd) {
        Vec3d offset = Vec3d.field_186680_a;
        IImmersiveConnectable iicPos = net.getConnector(pos.getPosition());
        Preconditions.checkArgument((!(iicPos instanceof IICProxy) ? 1 : 0) != 0);
        if (iicPos != null) {
            offset = iicPos.getConnectionOffset(conn, pos);
        }
        if (fromOtherEnd) {
            BlockPos posA = pos.getPosition();
            BlockPos posB = conn.getOtherEnd(pos).getPosition();
            offset = offset.func_72441_c((double)(posA.func_177958_n() - posB.func_177958_n()), (double)(posA.func_177956_o() - posB.func_177956_o()), (double)(posA.func_177952_p() - posB.func_177952_p()));
        }
        return offset;
    }

    public static Vec3d addVectors(Vec3d vec0, Vec3d vec1) {
        return vec0.func_72441_c(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    public static Vec3d[] getConnectionCatenary(Vec3d start, Vec3d end, double slack) {
        int vertices = 17;
        double dx = end.field_72450_a - start.field_72450_a;
        double dy = end.field_72448_b - start.field_72448_b;
        double dz = end.field_72449_c - start.field_72449_c;
        double dw = Math.sqrt(dx * dx + dz * dz);
        double k = Math.sqrt(dx * dx + dy * dy + dz * dz) * slack;
        double l = 0.0;
        for (int limiter = 0; limiter < 300; ++limiter) {
            if (!(Math.sinh(l += 0.01) / l >= Math.sqrt(k * k - dy * dy) / dw)) continue;
        }
        double a = dw / 2.0 / l;
        double offsetX = (0.0 + dw - a * Math.log((k + dy) / (k - dy))) * 0.5;
        double offsetY = (dy + 0.0 - k * Math.cosh(l) / Math.sinh(l)) * 0.5;
        Vec3d[] vex = new Vec3d[18];
        vex[0] = new Vec3d(start.field_72450_a, start.field_72448_b, start.field_72449_c);
        for (int i = 1; i < 17; ++i) {
            float posRelative = (float)i / 17.0f;
            double x = 0.0 + dx * (double)posRelative;
            double z = 0.0 + dz * (double)posRelative;
            double y = a * Math.cosh((dw * (double)posRelative - offsetX) / a) + offsetY;
            vex[i] = new Vec3d(start.field_72450_a + x, start.field_72448_b + y, start.field_72449_c + z);
        }
        vex[17] = new Vec3d(end.field_72450_a, end.field_72448_b, end.field_72449_c);
        return vex;
    }

    public static double getDim(Vec3d vec, int dim) {
        return dim == 0 ? vec.field_72450_a : (dim == 1 ? vec.field_72448_b : vec.field_72449_c);
    }

    public static BlockPos offsetDim(BlockPos p, int dim, int amount) {
        return p.func_177982_a(dim == 0 ? amount : 0, dim == 1 ? amount : 0, dim == 2 ? amount : 0);
    }

    public static Vec3d offsetDim(Vec3d p, int dim, double amount) {
        return p.func_72441_c(dim == 0 ? amount : 0.0, dim == 1 ? amount : 0.0, dim == 2 ? amount : 0.0);
    }

    public static void raytraceAlongCatenary(Connection conn, LocalWireNetwork net, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close) {
        Vec3d vStart = ApiUtils.getVecForIICAt(net, conn.getEndA(), conn, false);
        Vec3d vEnd = ApiUtils.getVecForIICAt(net, conn.getEndB(), conn, true);
        ApiUtils.raytraceAlongCatenaryRelative(conn, in, close, vStart, vEnd);
    }

    public static void raytraceAlongCatenaryRelative(Connection conn, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close, Vec3d vStart, Vec3d vEnd) {
        conn.generateCatenaryData(vStart, vEnd);
        BlockPos offset = conn.getEndA().getPosition();
        ApiUtils.raytraceAlongCatenary(conn.getCatenaryData(), offset, in, close);
    }

    public static void raytraceAlongCatenary(Connection.CatenaryData data, BlockPos offset, Consumer<Triple<BlockPos, Vec3d, Vec3d>> in, Consumer<Triple<BlockPos, Vec3d, Vec3d>> close) {
        CatenaryTracer ct = new CatenaryTracer(data, offset);
        ct.calculateIntegerIntersections();
        ct.forEachSegment(segment -> {
            if (segment.inBlock) {
                in.accept((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)segment.mainPos, (Object)segment.relativeSegmentStart, (Object)segment.relativeSegmentEnd));
            } else {
                close.accept((Triple<BlockPos, Vec3d, Vec3d>)new ImmutableTriple((Object)segment.mainPos, (Object)segment.relativeSegmentStart, (Object)segment.relativeSegmentEnd));
            }
        });
    }

    public static WireType getWireTypeFromNBT(CompoundNBT tag, String key) {
        return WireType.getValue(tag.func_74779_i(key));
    }

    public static ActionResultType doCoilUse(IWireCoil coil, PlayerEntity player, World world, BlockPos pos, Hand hand, Direction side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            ItemStack stack = player.func_184586_b(hand);
            TargetingInfo targetHere = new TargetingInfo(side, hitX - (float)pos.func_177958_n(), hitY - (float)pos.func_177956_o(), hitZ - (float)pos.func_177952_p());
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, targetHere);
            BlockPos offsetHere = pos.func_177973_b((Vec3i)masterPos);
            tileEntity = world.func_175625_s(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !((IImmersiveConnectable)tileEntity).canConnect()) {
                return ActionResultType.PASS;
            }
            IImmersiveConnectable iicHere = (IImmersiveConnectable)tileEntity;
            ConnectionPoint cpHere = iicHere.getTargetedPoint(targetHere, (Vec3i)offsetHere);
            if (cpHere == null || !((IImmersiveConnectable)tileEntity).canConnectCable(wire, cpHere, (Vec3i)offsetHere) || !coil.canConnectCable(stack, tileEntity)) {
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.wrongCable", new Object[0]), true);
                }
                return ActionResultType.FAIL;
            }
            if (!world.field_72995_K) {
                CompoundNBT nbt = stack.func_196082_o();
                if (!ItemNBTHelper.hasKey(stack, "linkingPos")) {
                    nbt.func_74778_a("linkingDim", world.func_201675_m().func_186058_p().getRegistryName().toString());
                    nbt.func_218657_a("linkingPos", (INBT)cpHere.createTag());
                    nbt.func_218657_a("linkingOffset", (INBT)NBTUtil.func_186859_a((BlockPos)offsetHere));
                } else {
                    ConnectionPoint cpLink = new ConnectionPoint(nbt.func_74775_l("linkingPos"));
                    ResourceLocation linkDimension = new ResourceLocation(nbt.func_74779_i("linkingDim"));
                    BlockPos linkOffset = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("linkingOffset"));
                    TileEntity tileEntityLinkingPos = world.func_175625_s(cpLink.getPosition());
                    int distanceSq = (int)Math.ceil(cpLink.getPosition().func_177951_i((Vec3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (!linkDimension.equals((Object)world.func_201675_m().func_186058_p().getRegistryName())) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.wrongDimension", new Object[0]), true);
                    } else if (cpLink.getPosition().equals((Object)masterPos)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.sameConnection", new Object[0]), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.tooFar", new Object[0]), true);
                    } else {
                        TargetingInfo targetLink = TargetingInfo.readFromNBT(ItemNBTHelper.getTagCompound(stack, "targettingInfo"));
                        if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.invalidPoint", new Object[0]), true);
                        } else {
                            IImmersiveConnectable iicLink = (IImmersiveConnectable)tileEntityLinkingPos;
                            if (!(((IImmersiveConnectable)tileEntityLinkingPos).canConnectCable(wire, cpLink, (Vec3i)linkOffset) && ((IImmersiveConnectable)tileEntityLinkingPos).getConnectionMaster(wire, targetLink).equals((Object)cpLink.getPosition()) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.invalidPoint", new Object[0]), true);
                            } else {
                                Collection<Connection> outputs;
                                LocalWireNetwork localB;
                                GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                                assert (cpHere != null && cpLink != null);
                                boolean connectionExists = false;
                                LocalWireNetwork localA = net.getLocalNet(cpHere);
                                if (localA == (localB = net.getLocalNet(cpLink)) && (outputs = localA.getConnections(cpHere)) != null) {
                                    for (Connection con : outputs) {
                                        if (con.isInternal() || !con.getOtherEnd(cpHere).equals(cpLink)) continue;
                                        connectionExists = true;
                                    }
                                }
                                if (connectionExists) {
                                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.connectionExists", new Object[0]), true);
                                } else {
                                    HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                    ignore.addAll(iicHere.getIgnored(iicLink));
                                    ignore.addAll(iicLink.getIgnored(iicHere));
                                    HashSet<BlockPos> failedReasons = new HashSet<BlockPos>();
                                    Connection tempConn = new Connection(wire, cpHere, cpLink);
                                    Vec3d start = iicHere.getConnectionOffset(tempConn, cpHere);
                                    Vec3d end = iicLink.getConnectionOffset(tempConn, cpLink);
                                    ApiUtils.raytraceAlongCatenaryRelative(tempConn, p -> {
                                        if (!ignore.contains(p.getLeft())) {
                                            BlockState state = world.func_180495_p((BlockPos)p.getLeft());
                                            if (ApiUtils.preventsConnection(world, (BlockPos)p.getLeft(), state, (Vec3d)p.getMiddle(), (Vec3d)p.getRight())) {
                                                failedReasons.add((BlockPos)p.getLeft());
                                            }
                                        }
                                    }, p -> {}, start, end.func_178787_e(new Vec3d((Vec3i)cpLink.getPosition().func_177973_b((Vec3i)masterPos))));
                                    if (failedReasons.isEmpty()) {
                                        Connection conn = new Connection(wire, cpHere, cpLink);
                                        net.addConnection(conn);
                                        iicHere.connectCable(wire, cpHere, iicLink, cpLink);
                                        iicLink.connectCable(wire, cpLink, iicHere, cpHere);
                                        Utils.unlockIEAdvancement(player, "main/connect_wire");
                                        if (!player.field_71075_bZ.field_75098_d) {
                                            coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                        }
                                        ((TileEntity)iicHere).func_70296_d();
                                        world.func_175641_c(masterPos, ((TileEntity)iicHere).func_195044_w().func_177230_c(), -1, 0);
                                        BlockState state = world.func_180495_p(masterPos);
                                        world.func_184138_a(masterPos, state, state, 3);
                                        ((TileEntity)iicLink).func_70296_d();
                                        world.func_175641_c(cpLink.getPosition(), tileEntityLinkingPos.func_195044_w().func_177230_c(), -1, 0);
                                        state = world.func_180495_p(cpLink.getPosition());
                                        world.func_184138_a(cpLink.getPosition(), state, state, 3);
                                    } else {
                                        player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.immersiveengineering.warning.cantSee", new Object[0]), true);
                                        ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f((BlockPos)failedReasons.iterator().next())), (Object)new MessageObstructedConnection(tempConn, failedReasons));
                                    }
                                }
                            }
                        }
                    }
                    ItemNBTHelper.remove(stack, "linkingDim");
                    ItemNBTHelper.remove(stack, "linkingPos");
                    ItemNBTHelper.remove(stack, "linkingOffset");
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static Object convertToValidRecipeInput(Object input) {
        if (input instanceof Tag) {
            input = ((Tag)input).func_199886_b();
        }
        if (input instanceof ItemStack) {
            return input;
        }
        if (input instanceof Item) {
            return new ItemStack((IItemProvider)((Item)input));
        }
        if (input instanceof Block) {
            return new ItemStack((IItemProvider)((Block)input));
        }
        if (input instanceof List) {
            return input;
        }
        if (input instanceof ResourceLocation) {
            return input;
        }
        throw new RuntimeException("Recipe Inputs must always be ItemStack, Item, Block or ResourceLocation (tag name), " + input + " is invalid");
    }

    public static boolean hasPlayerIngredient(PlayerEntity player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (Hand hand : Hand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.test(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.test(itemstack) || (amount -= itemstack.func_190916_E()) > 0) continue;
            return true;
        }
        return amount <= 0;
    }

    public static void consumePlayerIngredient(PlayerEntity player, IngredientWithSize ingredient) {
        ItemStack itemstack;
        int amount = ingredient.getCount();
        for (Hand hand : Hand.values()) {
            itemstack = player.func_184586_b(hand);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            if (!ingredient.testIgnoringSize(itemstack)) continue;
            int taken = Math.min(amount, itemstack.func_190916_E());
            amount -= taken;
            itemstack.func_190918_g(taken);
            if (itemstack.func_190916_E() <= 0) {
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (amount > 0) continue;
            return;
        }
    }

    public static <T extends Comparable<T>> Map<T, Integer> sortMap(Map<T, Integer> map, boolean inverse) {
        TreeMap<T, Integer> sortedMap = new TreeMap<T, Integer>(new ValueComparator<T>(map, inverse));
        sortedMap.putAll(map);
        return sortedMap;
    }

    public static <T extends TileEntity> void checkForNeedlessTicking(T te) {
        if (!te.func_145831_w().field_72995_K && ((IEBlockInterfaces.IGeneralMultiblock)te).isDummy()) {
            EventHandler.REMOVE_FROM_TICKING.add(te);
        }
    }

    public static boolean preventsConnection(World worldIn, BlockPos pos, BlockState state, Vec3d a, Vec3d b) {
        for (AxisAlignedBB aabb : state.func_196952_d((IBlockReader)worldIn, pos).func_197756_d()) {
            if (!(aabb = aabb.func_186662_g(1.0E-5)).func_72318_a(a) && !aabb.func_72318_a(b) && !aabb.func_216365_b(a, b).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static void knockbackNoSource(LivingEntity entity, double strength, double xRatio, double zRatio) {
        entity.field_70160_al = true;
        Vec3d motionOld = entity.func_213322_ci();
        Vec3d toAdd = new Vec3d(xRatio, 0.0, zRatio).func_72432_b().func_186678_a(strength);
        entity.func_213293_j(motionOld.field_72450_a / 2.0 - toAdd.field_72450_a, entity.field_70122_E ? Math.min(0.4, motionOld.field_72448_b / 2.0 + strength) : motionOld.field_72448_b, motionOld.field_72449_c / 2.0 - toAdd.field_72449_c);
    }

    public static Connection raytraceWires(World world, Vec3d start, Vec3d end, @Nullable Connection ignored) {
        GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
        WireCollisionData collisionData = global.getCollisionData();
        AtomicReference ret = new AtomicReference();
        AtomicDouble minDistSq = new AtomicDouble(Double.POSITIVE_INFINITY);
        Utils.rayTrace(start, end, world, pos -> {
            Collection<WireCollisionData.CollisionInfo> infoAtPos = collisionData.getCollisionInfo((BlockPos)pos);
            for (WireCollisionData.CollisionInfo wireInfo : infoAtPos) {
                Connection c = wireInfo.conn;
                if (ignored != null && c.hasSameConnectors(ignored)) continue;
                Vec3d startRelative = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                Vec3d across = wireInfo.intersectB.func_178788_d(wireInfo.intersectA);
                double t = Utils.getCoeffForMinDistance(startRelative, wireInfo.intersectA, across);
                Vec3d closest = wireInfo.intersectA.func_72441_c((t = MathHelper.func_151237_a((double)t, (double)0.0, (double)1.0)) * across.field_72450_a, t * across.field_72448_b, t * across.field_72449_c);
                double distSq = closest.func_72436_e(startRelative);
                if (!(distSq < minDistSq.get())) continue;
                ret.set(c);
                minDistSq.set(distSq);
            }
        });
        return (Connection)ret.get();
    }

    public static Connection getConnectionMovedThrough(World world, LivingEntity e) {
        Vec3d start = e.func_174824_e(0.0f);
        Vec3d end = e.func_174824_e(1.0f);
        return ApiUtils.raytraceWires(world, start, end, null);
    }

    public static Connection getTargetConnection(World world, PlayerEntity player, Connection ignored, double maxDistance) {
        Vec3d look = player.func_70040_Z();
        Vec3d start = player.func_174824_e(1.0f);
        Vec3d end = start.func_178787_e(look.func_186678_a(maxDistance));
        return ApiUtils.raytraceWires(world, start, end, ignored);
    }

    public static void addFutureServerTask(World world, Runnable task, boolean forceFuture) {
        LogicalSide side = world.field_72995_K ? LogicalSide.CLIENT : LogicalSide.SERVER;
        ThreadTaskExecutor tmp = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(side);
        if (forceFuture) {
            int tick = world.field_72995_K ? 0 : ((MinecraftServer)tmp).func_71259_af();
            tmp.func_212871_a_((Runnable)new TickDelayedTask(tick, task));
        } else {
            tmp.func_213165_a(task);
        }
    }

    public static void addFutureServerTask(World world, Runnable task) {
        ApiUtils.addFutureServerTask(world, task, false);
    }

    public static void moveConnectionEnd(Connection conn, ConnectionPoint currEnd, ConnectionPoint newEnd, World world) {
        ConnectionPoint fixedPos = conn.getOtherEnd(currEnd);
        GlobalWireNetwork globalNet = GlobalWireNetwork.getNetwork(world);
        globalNet.removeConnection(conn);
        globalNet.addConnection(new Connection(conn.type, fixedPos, newEnd));
    }

    public static <T> LazyOptional<T> constantOptional(T val) {
        return LazyOptional.of(() -> val);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Function<BakedQuad, BakedQuad> transformQuad(TransformationMatrix transform, Int2IntFunction colorMultiplier) {
        return new QuadTransformer(transform, colorMultiplier);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class QuadTransformer
    implements Function<BakedQuad, BakedQuad> {
        @Nonnull
        private final TransformationMatrix transform;
        @Nullable
        private final Int2IntFunction colorTransform;
        private BakedQuadBuilder currentQuadBuilder;
        private IVertexConsumer transformer = this.createConsumer(DefaultVertexFormats.field_176600_a);

        private QuadTransformer(TransformationMatrix transform, @Nullable Int2IntFunction colorTransform) {
            this.transform = transform;
            this.colorTransform = colorTransform;
        }

        @Override
        public BakedQuad apply(BakedQuad q) {
            this.currentQuadBuilder = new BakedQuadBuilder(q.func_187508_a());
            q.pipe(this.transformer);
            return this.currentQuadBuilder.build();
        }

        private IVertexConsumer createConsumer(final VertexFormat f) {
            int posPos = -1;
            int normPos = -1;
            int colorPos = -1;
            for (int i = 0; i < f.func_227894_c_().size(); ++i) {
                if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() == VertexFormatElement.Usage.POSITION) {
                    posPos = i;
                    continue;
                }
                if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() == VertexFormatElement.Usage.NORMAL) {
                    normPos = i;
                    continue;
                }
                if (((VertexFormatElement)f.func_227894_c_().get(i)).func_177375_c() != VertexFormatElement.Usage.COLOR) continue;
                colorPos = i;
            }
            if (posPos == -1) {
                return null;
            }
            final int posPosFinal = posPos;
            final int normPosFinal = normPos;
            final int colorPosFinal = colorPos;
            return new IVertexConsumer(){
                int tintIndex = -1;

                @Nonnull
                public VertexFormat getVertexFormat() {
                    return f;
                }

                public void setQuadTint(int tint) {
                    currentQuadBuilder.setQuadTint(tint);
                    this.tintIndex = tint;
                }

                public void setQuadOrientation(@Nonnull Direction orientation) {
                    Vec3i normal = orientation.func_176730_m();
                    Vector3f newFront = new Vector3f((float)normal.func_177958_n(), (float)normal.func_177956_o(), (float)normal.func_177952_p());
                    transform.transformNormal(newFront);
                    Direction newOrientation = Direction.func_176737_a((float)newFront.func_195899_a(), (float)newFront.func_195900_b(), (float)newFront.func_195902_c());
                    currentQuadBuilder.setQuadOrientation(newOrientation);
                }

                public void setApplyDiffuseLighting(boolean diffuse) {
                    currentQuadBuilder.setApplyDiffuseLighting(diffuse);
                }

                public void setTexture(@Nonnull TextureAtlasSprite texture) {
                    currentQuadBuilder.setTexture(texture);
                }

                public void put(int element, float ... data) {
                    int multiplier;
                    if (element == posPosFinal && transform != null) {
                        Vector4f newPos = new Vector4f(data[0], data[1], data[2], 1.0f);
                        transform.transformPosition(newPos);
                        data = new float[]{newPos.func_195910_a(), newPos.func_195913_b(), newPos.func_195914_c()};
                    } else if (element == normPosFinal) {
                        Vector3f newNormal = new Vector3f(data[0], data[1], data[2]);
                        transform.transformNormal(newNormal);
                        data = new float[]{newNormal.func_195899_a(), newNormal.func_195900_b(), newNormal.func_195902_c()};
                    } else if (element == colorPosFinal && this.tintIndex != -1 && colorTransform != null && (multiplier = ((Integer)colorTransform.apply((Object)this.tintIndex)).intValue()) != 0) {
                        float r = (float)(multiplier >> 16 & 0xFF) / 255.0f;
                        float g = (float)(multiplier >> 8 & 0xFF) / 255.0f;
                        float b = (float)(multiplier & 0xFF) / 255.0f;
                        float[] oldData = data;
                        data = new float[]{oldData[0] * r, oldData[1] * g, oldData[2] * b, oldData[3]};
                    }
                    currentQuadBuilder.put(element, data);
                }
            };
        }
    }

    public static class ValueComparator<T extends Comparable<T>>
    implements Comparator<T> {
        Map<T, Integer> base;
        boolean inverse;

        public ValueComparator(Map<T, Integer> base, boolean inverse) {
            this.base = base;
            this.inverse = inverse;
        }

        @Override
        public int compare(T s0, T s1) {
            int v1;
            int v0 = this.base.get(s0);
            int ret = v0 > (v1 = this.base.get(s1).intValue()) ? -1 : (v0 < v1 ? 1 : s0.compareTo(s1));
            return ret * (this.inverse ? -1 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ValueComparator)) {
                return false;
            }
            ValueComparator other = (ValueComparator)obj;
            return other.base == this.base && other.inverse == this.inverse;
        }
    }
}

