/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import org.lwjgl.opengl.GL11;

public class TextureUtils {
    public static void func_147645_c(int textureID) {
        GL11.glDeleteTextures((int)textureID);
    }

    public static void func_227760_t_(int textureID) {
        GlStateManager.func_227760_t_((int)textureID);
    }

    public static void prepareImage(int textureID, int width, int height) {
        TextureUtil.func_225680_a_((int)textureID, (int)width, (int)height);
    }

    @Nullable
    static NativeImage getRightSkin(NativeImage image) {
        if (image == null) {
            return null;
        }
        if (image.func_195702_a() % 64 == 0 && image.func_195714_b() % 64 == 0 && image.func_195714_b() == image.func_195702_a()) {
            return image;
        }
        NativeImage temp = new NativeImage(image.func_195702_a(), image.func_195714_b() * 2, true);
        int m = image.func_195702_a() / 64;
        for (int i = 0; i < image.func_195702_a(); ++i) {
            for (int j = 0; j < image.func_195714_b(); ++j) {
                if (j >= 16 * m && j < 32 * m) {
                    if (i < m * 16) {
                        temp.func_195700_a(16 * m + i, 32 * m + j, image.func_195709_a(i, j));
                    } else if (i >= 40 * m && i < 56 * m) {
                        temp.func_195700_a(-8 * m + i, 32 * m + j, image.func_195709_a(i, j));
                    }
                }
                temp.func_195700_a(i, j, image.func_195709_a(i, j));
            }
        }
        return temp;
    }

    @Nullable
    static BufferedImage getRightSkin(BufferedImage image) {
        if (image == null) {
            return null;
        }
        if (image.getWidth() % 64 == 0 && image.getHeight() % 64 == 0 && image.getHeight() == image.getWidth()) {
            return image;
        }
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight() * 2, 6);
        int m = image.getWidth() / 64;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                if (j >= 16 * m && j < 32 * m) {
                    if (i < m * 4) {
                        temp.setRGB(m * 20 - i, 32 * m + j, image.getRGB(i, j));
                    } else if (i < m * 8) {
                        temp.setRGB(m * 28 - i, 32 * m + j, image.getRGB(i, j));
                    } else if (i < m * 12) {
                        temp.setRGB(m * 36 - i, 32 * m + j, image.getRGB(i, j));
                    } else if (i < m * 16) {
                        temp.setRGB(m * 44 - i, 32 * m + j, image.getRGB(i, j));
                    }
                    if (i >= 40 * m) {
                        if (i < 44 * m) {
                            temp.setRGB(76 * m - i, 32 * m + j, image.getRGB(i, j));
                        } else if (i < 48 * m) {
                            temp.setRGB(84 * m - i, 32 * m + j, image.getRGB(i, j));
                        } else if (i < 52 * m) {
                            temp.setRGB(92 * m - i, 32 * m + j, image.getRGB(i, j));
                        } else if (i < 56 * m) {
                            temp.setRGB(100 * m - i, 32 * m + j, image.getRGB(i, j));
                        }
                    }
                }
                temp.setRGB(i, j, image.getRGB(i, j));
            }
        }
        return temp;
    }

    static BufferedImage resize(BufferedImage img, int newW, int newH) {
        Image tmp = img.getScaledInstance(newW, newH, 4);
        BufferedImage dimg = new BufferedImage(newW, newH, 2);
        Graphics2D g2d = dimg.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return dimg;
    }
}

