/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.sun.management.OperatingSystemMXBean;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.NativeImage;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.model.MinecraftProfileTextureDTO;
import org.tlauncher.model.MinecraftTexturesPayload1;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.PreparedTextureData;
import org.tlauncher.renderer.texture.LightTexture;
import org.tlauncher.util.MinecraftUtils;
import org.tlauncher.util.TextureUtils;

public class PreparedProfileManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ExecutorService pool = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).build());
    private final Set<PlayerName> addedNames = new HashSet<PlayerName>();
    private LinkedBlockingQueue<PreparedTextureData> preparedData = new LinkedBlockingQueue();
    private static final int UP_VERGE_LOAD_FRAME = 15;
    private static int machinePerformance = 1;

    public PreparedProfileManager() {
        this.calculateSizeCape();
        this.addNewName(new PlayerName(MinecraftUtils.getSessionUsername()));
    }

    private void calculateSizeCape() {
        try {
            long memory = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            if ((memory /= 0x100000L) < 4000L) {
                machinePerformance = 2;
                LOGGER.debug(String.format("total memory %s ,performance %s ", memory, machinePerformance));
                return;
            }
            PreparedTextureData texture = new PreparedTextureData();
            final MinecraftProfileTextureDTO test = new MinecraftProfileTextureDTO();
            test.setCapeHeight(272);
            test.setAnimatedCape(true);
            texture.setProfileTextureDTO((Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>)new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>(){
                {
                    this.put(MinecraftProfileTexture.Type.CAPE, test);
                }
            });
            final NativeImage nativeImage = MinecraftUtils.readNativeImage(PreparedProfileManager.class.getResourceAsStream("cape_test_272.png"));
            texture.setImages((Map<MinecraftProfileTexture.Type, NativeImage>)new HashMap<MinecraftProfileTexture.Type, NativeImage>(){
                {
                    this.put(MinecraftProfileTexture.Type.CAPE, nativeImage);
                }
            });
            List<NativeImage> list = this.cutAnimatedCape(texture, test);
            long l = System.currentTimeMillis();
            for (NativeImage b : list) {
                LightTexture lightTexture = new LightTexture(b);
                lightTexture.close();
            }
            l = (System.currentTimeMillis() - l) / (long)list.size();
            if (l > 15L) {
                machinePerformance = 2;
            }
            LOGGER.debug(String.format("middle time to prepare frame of the cape is %s, performance %s", l, machinePerformance));
        }
        catch (Throwable t) {
            LOGGER.error("couldn't calculate size of the cape", t);
        }
    }

    private void fillGameProfileData(PlayerName name, GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return;
        }
        try {
            String json = new String(Base64.decodeBase64((String)textureProperty.getValue()), StandardCharsets.UTF_8);
            Gson g = new Gson();
            MinecraftTexturesPayload1 result = (MinecraftTexturesPayload1)g.fromJson(json, MinecraftTexturesPayload1.class);
            name.fill(result);
        }
        catch (JsonParseException e) {
            LOGGER.warn("Could not decode textures payload", (Throwable)e);
        }
    }

    public void addNewName(PlayerName p) {
        if (!this.addedNames.contains(p)) {
            this.addedNames.add(p);
            this.loadByName(p);
        }
    }

    private void loadByName(PlayerName p) {
        CompletableFuture.runAsync(() -> {
            PreparedTextureData texture = new PreparedTextureData();
            texture.setName(p);
            try {
                Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profile = this.loadProfileData0(p);
                this.fillIfEmptyWithNativeGameProfileTextures(profile, p);
                texture.setProfileTextureDTO(profile);
                this.downloadAndValidateImage(profile, texture);
                this.preparedFramesForCape(texture);
                this.preparedFrameForSkin(texture);
                LOGGER.debug("finished downloading data " + p.getName() + " " + p.getDisplayName());
            }
            catch (Throwable io) {
                LOGGER.warn("error " + p.toString(), io);
            }
            this.preparedData.add(texture);
        }, this.pool);
    }

    private void fillIfEmptyWithNativeGameProfileTextures(Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profile, PlayerName p) {
        if (profile.isEmpty() && Objects.nonNull(p.getNativeTextures())) {
            p.getNativeTextures().forEach((k, v) -> {
                MinecraftProfileTextureDTO m = new MinecraftProfileTextureDTO();
                m.setUrl(v.getUrl());
                profile.put((MinecraftProfileTexture.Type)k, m);
            });
        }
    }

    private void preparedFrameForSkin(PreparedTextureData texture) {
        NativeImage image = texture.getImages().get(MinecraftProfileTexture.Type.SKIN);
        if (Objects.nonNull(image)) {
            texture.setSkin(image);
        }
    }

    private void preparedFramesForCape(PreparedTextureData texture) {
        MinecraftProfileTextureDTO p = texture.getProfileTextureDTO().get(MinecraftProfileTexture.Type.CAPE);
        if (Objects.isNull(p)) {
            return;
        }
        if (!Objects.equals(p.isAnimatedCape(), true)) {
            NativeImage nativeImage = texture.getImages().get(MinecraftProfileTexture.Type.CAPE);
            p.setCapeWidth(nativeImage.func_195702_a());
            p.setCapeHeight(nativeImage.func_195714_b());
            texture.getCapeFrames().add(nativeImage);
            return;
        }
        for (NativeImage image : this.cutAnimatedCape(texture, p)) {
            texture.getCapeFrames().add(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NativeImage> cutAnimatedCape(PreparedTextureData texture, MinecraftProfileTextureDTO p) {
        try (NativeImage image = texture.getImages().get(MinecraftProfileTexture.Type.CAPE);){
            int frameHeight = p.getCapeHeight();
            int frameWidth = p.getCapeHeight() / 17 * 22;
            p.setCapeWidth(frameWidth);
            int xFrames = image.func_195702_a() / frameWidth;
            int yFrames = image.func_195714_b() / frameHeight;
            ArrayList<NativeImage> list = new ArrayList<NativeImage>();
            for (int j = 0; j < xFrames; ++j) {
                for (int i = 0; i < yFrames; ++i) {
                    NativeImage image1 = new NativeImage(frameWidth / 22 * 64, frameHeight / 17 * 32, true);
                    boolean flag = false;
                    for (int y = 0; y < frameHeight; ++y) {
                        for (int x = 0; x < frameWidth; ++x) {
                            int alpha;
                            int color = image.func_195709_a(j * frameWidth + x, i * frameHeight + y);
                            if (!flag && (alpha = color >>> 24 & 0xFF) != 0) {
                                flag = true;
                            }
                            try {
                                image1.func_195700_a(x, y, color);
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                LOGGER.error("Coordinates: x " + x + " y " + y + " color " + color, (Throwable)e);
                            }
                        }
                    }
                    if (!flag) {
                        ArrayList<NativeImage> arrayList = list;
                        return arrayList;
                    }
                    list.add(image1);
                }
            }
            ArrayList<NativeImage> arrayList = list;
            return arrayList;
        }
    }

    private void downloadAndValidateImage(Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> profile, PreparedTextureData texture) throws IOException {
        for (Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> entry : profile.entrySet()) {
            MinecraftProfileTextureDTO texture1;
            BufferedImage image = this.getImage(entry);
            if (entry.getKey().equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                image = TextureUtils.getRightSkin(image);
            }
            if (image == null) {
                return;
            }
            if (!(!entry.getKey().equals((Object)MinecraftProfileTexture.Type.CAPE) || image.getWidth() % 22 == 0 && image.getHeight() % 17 == 0 || image.getWidth() % 64 == 0 && image.getHeight() % 32 == 0)) {
                LOGGER.warn("not proper cape");
                continue;
            }
            if (entry.getKey().equals((Object)MinecraftProfileTexture.Type.CAPE) && machinePerformance == 2 && (texture1 = profile.get(MinecraftProfileTexture.Type.CAPE)).isAnimatedCape().booleanValue() && texture1.getCapeHeight() > 200) {
                int resizeValue = 2;
                texture1.setCapeHeight(texture1.getCapeHeight() / resizeValue);
                image = TextureUtils.resize(image, image.getWidth() / resizeValue, image.getHeight() / resizeValue);
            }
            NativeImage nativeImage = this.getNativeImage(image);
            texture.getImages().put(entry.getKey(), nativeImage);
        }
    }

    private NativeImage getNativeImage(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        return MinecraftUtils.readNativeImage(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(Map.Entry<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> entry) throws IOException {
        IOException exception = new IOException("can't load image");
        for (int i = 0; i < 3; ++i) {
            URLConnection c = null;
            try {
                c = (HttpURLConnection)new URL(entry.getValue().getUrl()).openConnection();
                c.setConnectTimeout(40000);
                c.setReadTimeout(30000);
                BufferedImage bufferedImage = ImageIO.read(c.getInputStream());
                return bufferedImage;
            }
            catch (IOException io) {
                exception = io;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            finally {
                if (Objects.nonNull(c)) {
                    IOUtils.closeQuietly((InputStream)c.getInputStream());
                }
            }
        }
        throw exception;
    }

    private Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> loadProfileData0(PlayerName playerName) throws IOException {
        IOException exception = new IOException("can't download model");
        for (int i = 0; i < 3; ++i) {
            try {
                return this.loadProfileData(playerName.getName());
            }
            catch (IOException e) {
                exception = e;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw exception;
    }

    public void addNewName(GameProfile p, PlayerName name) {
        if (!this.addedNames.contains(name)) {
            this.addedNames.add(name);
            this.fillGameProfileData(name, p);
            this.loadByName(name);
        }
    }

    private Map<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO> loadProfileData(String playerName) throws IOException {
        Gson gson = new Gson();
        if (Objects.nonNull(System.getProperty("memoryLeakTest"))) {
            playerName = "rob6";
        }
        playerName = URLEncoder.encode(playerName, "UTF-8");
        URL url = new URL(String.format("http://auth.tlauncher.org/skin/profile/texture/login/%s", playerName));
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(40000);
        urlConnection.setReadTimeout(30000);
        StringWriter writer = new StringWriter();
        try (InputStream inputStream = urlConnection.getInputStream();){
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (Charset)StandardCharsets.UTF_8);
        }
        String response = writer.toString();
        return (Map)gson.fromJson(response, new TypeToken<HashMap<MinecraftProfileTexture.Type, MinecraftProfileTextureDTO>>(){}.getType());
    }

    public PreparedTextureData peek() {
        return this.preparedData.peek();
    }

    public void poll() {
        this.preparedData.poll();
    }

    public void removeByName(PlayerName name) {
        this.addedNames.remove(name);
    }
}

