/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.texture;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import org.tlauncher.renderer.texture.LightTexture;

public class FramedTexture {
    private static int frameIndex;
    private int currentFrameIndex;
    private long lastTimNano = System.nanoTime();
    private final long updatingTextureInNano;
    private boolean animated;
    private List<ResourceLocation> frames;

    public FramedTexture(long updatingTextureInNano, boolean animated) {
        this.updatingTextureInNano = updatingTextureInNano;
        this.frames = new ArrayList<ResourceLocation>();
        this.animated = animated;
    }

    public FramedTexture(int framesSize, long updatingTextureInNano, boolean animated) {
        this(updatingTextureInNano, animated);
        this.frames = new ArrayList<ResourceLocation>(framesSize);
    }

    public static FramedTexture createOneFramedTexture(NativeImage nativeImage) {
        FramedTexture texture = new FramedTexture(1L, false);
        ResourceLocation resourceLocation = new ResourceLocation(String.format("dynamic/framedtexture%s.png", FramedTexture.getNextFrameIndex()));
        LightTexture lightTexture = new LightTexture(nativeImage);
        Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)lightTexture);
        texture.frames.add(resourceLocation);
        return texture;
    }

    public void initByOneImage(NativeImage nativeImage) {
        ResourceLocation res = new ResourceLocation("dynamic/framedtexture" + FramedTexture.getNextFrameIndex() + ".png");
        Texture object = Minecraft.func_71410_x().func_110434_K().func_229267_b_(res);
        if (object == null) {
            object = new LightTexture(nativeImage);
            Minecraft.func_71410_x().func_110434_K().func_229263_a_(res, object);
        }
        this.frames.add(res);
    }

    private ResourceLocation getFrame(int index) {
        return this.frames.get(index);
    }

    private static int getNextFrameIndex() {
        return ++frameIndex;
    }

    public ResourceLocation getFrame() {
        if (!this.animated) {
            return this.getFrame(0);
        }
        if (System.nanoTime() - this.lastTimNano >= this.updatingTextureInNano) {
            this.lastTimNano = System.nanoTime();
            this.currentFrameIndex = this.currentFrameIndex + 1 < this.frames.size() ? ++this.currentFrameIndex : 0;
        }
        return this.frames.get(this.currentFrameIndex);
    }

    public List<ResourceLocation> getFrames() {
        return this.frames;
    }
}

