/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.model.MinecraftProfileTextureDTO;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.PreparedTextureData;
import org.tlauncher.model.ProfileTexture;
import org.tlauncher.renderer.texture.FramedTexture;
import org.tlauncher.renderer.texture.LightTexture;
import org.tlauncher.util.MinecraftUtils;
import org.tlauncher.util.PreparedProfileManager;

public class TextureManager {
    private final Logger LOGGER = LogManager.getLogger(this.getClass());
    private final Map<PlayerName, ProfileTexture> textures = new HashMap<PlayerName, ProfileTexture>();
    private static long TIME_GUP = 2000L;
    private PreparedProfileManager preparedProfileManager;
    private long updateTime;
    private long last;
    private static int index = 0;

    private void cleanOldTextures() {
        if (this.last < System.currentTimeMillis()) {
            long l = System.currentTimeMillis();
            List<PlayerName> removed = this.textures.entrySet().stream().filter(e -> l > ((ProfileTexture)e.getValue()).getTime()).map(Map.Entry::getKey).collect(Collectors.toList());
            PlayerName n = new PlayerName(MinecraftUtils.getSessionUsername());
            removed.remove(n);
            for (PlayerName s : removed) {
                LightTexture texture;
                ProfileTexture profileTexture = this.textures.get(s);
                if (Objects.nonNull(profileTexture.getSkin()) && (texture = (LightTexture)Minecraft.func_71410_x().func_110434_K().func_229267_b_(profileTexture.getSkin())) != null) {
                    texture.close();
                }
                if (!Objects.nonNull(profileTexture.getCape())) continue;
                for (ResourceLocation resourceLocation : this.textures.get(s).getCape().getFrames()) {
                    LightTexture texture2 = (LightTexture)Minecraft.func_71410_x().func_110434_K().func_229267_b_(resourceLocation);
                    if (texture2 == null) continue;
                    texture2.close();
                }
            }
            removed.forEach(this.textures::remove);
            this.LOGGER.trace(String.format("removed %s , during %s", String.join((CharSequence)",", removed.stream().map(PlayerName::getName).collect(Collectors.toList())), System.currentTimeMillis() - l));
            this.last = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(15L);
        }
    }

    public boolean isInit(PlayerName n, MinecraftProfileTexture.Type type) {
        ProfileTexture p = this.textures.get(n);
        if (Objects.isNull(p)) {
            return false;
        }
        this.updateCache(n);
        switch (type) {
            case SKIN: {
                return true;
            }
            case CAPE: {
                return p.isCapeReady();
            }
        }
        return false;
    }

    private void updateCache(PlayerName p) {
        if (this.updateTime < System.currentTimeMillis()) {
            this.updateTime = System.currentTimeMillis() + TIME_GUP;
            ProfileTexture profileTexture = this.textures.get(p);
            if (Objects.nonNull(profileTexture)) {
                this.LOGGER.debug("updated cache value " + p);
                profileTexture.updateTime();
            }
        }
    }

    public void createFramedTextures() {
        long l = System.currentTimeMillis();
        this.cleanOldTextures();
        PreparedTextureData preparedTextureData = this.preparedProfileManager.peek();
        if (Objects.isNull(preparedTextureData)) {
            return;
        }
        PlayerName playerName = preparedTextureData.getName();
        ProfileTexture profile = this.textures.get(playerName);
        try {
            MinecraftProfileTextureDTO p;
            NativeImage image = preparedTextureData.getImages().get(MinecraftProfileTexture.Type.CAPE);
            if (Objects.isNull(profile)) {
                profile = new ProfileTexture();
                profile.updateTime();
                this.textures.put(playerName, profile);
                NativeImage skin = preparedTextureData.getImages().get(MinecraftProfileTexture.Type.SKIN);
                ResourceLocation resourceLocation = null;
                if (Objects.nonNull(skin)) {
                    resourceLocation = new ResourceLocation(String.format("dynamic/skin_%s", index++));
                    LightTexture textureObject = new LightTexture(skin);
                    Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)textureObject);
                    Map<String, String> map = preparedTextureData.getProfileTextureDTO().get(MinecraftProfileTexture.Type.SKIN).getMetadata();
                    if (Objects.nonNull(map)) {
                        profile.setSkinType(map.get("model"));
                    }
                }
                profile.setSkin(resourceLocation);
                if (Objects.nonNull(image)) {
                    return;
                }
            }
            if (Objects.nonNull(p = preparedTextureData.getProfileTextureDTO().get(MinecraftProfileTexture.Type.CAPE)) && !preparedTextureData.getCapeFrames().isEmpty()) {
                if (Objects.equals(p.isAnimatedCape(), true)) {
                    FramedTexture cape = profile.getCape();
                    if (Objects.isNull(cape)) {
                        int fps = p.getFps() > 0 ? p.getFps() : 1;
                        cape = new FramedTexture(p.getCapeHeight(), 1000000000L / (long)fps, true);
                        profile.setCape(cape);
                    }
                    if (!this.fillCape(preparedTextureData, cape)) {
                        return;
                    }
                } else {
                    profile.setCape(FramedTexture.createOneFramedTexture(preparedTextureData.getCapeFrames().get(0)));
                }
            }
        }
        catch (Throwable e) {
            this.LOGGER.error((Object)e);
            e.printStackTrace();
        }
        if (profile.getSkinType() == null) {
            profile.setSkinType("undefined");
        }
        this.setReady(playerName, profile);
        this.preparedProfileManager.poll();
        long t = System.currentTimeMillis() - l;
        if (preparedTextureData.getMaxTimeLoad() < t) {
            preparedTextureData.setMaxTimeLoad(t);
        }
        this.LOGGER.info(String.format("textures '%s' was added, skin: %s,cape: %s, max waiting: %s ,during : %s ", playerName.getDisplayName(), Objects.nonNull(profile.getSkin()), Objects.nonNull(profile.getCape()), preparedTextureData.getMaxTimeLoad(), System.currentTimeMillis() - preparedTextureData.getInitTime()));
    }

    private boolean fillCape(PreparedTextureData preparedTextureData, FramedTexture cape) {
        int size = preparedTextureData.getCapeFrames().size();
        for (int i = 1; i > 0 && cape.getFrames().size() < size; --i) {
            int index = cape.getFrames().size();
            cape.initByOneImage(preparedTextureData.getCapeFrames().get(index));
        }
        return size == cape.getFrames().size();
    }

    private void setReady(PlayerName playerName, ProfileTexture profile) {
        profile.setCapeReady(true);
        this.preparedProfileManager.removeByName(playerName);
    }

    public void setPreparedProfileManager(PreparedProfileManager preparedProfileManager) {
        this.preparedProfileManager = preparedProfileManager;
    }

    public ProfileTexture get(PlayerName username) {
        return this.textures.get(username);
    }
}

