/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Objects;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.model.PlayerName;
import org.tlauncher.model.ProfileTexture;
import org.tlauncher.renderer.TextureManager;
import org.tlauncher.renderer.texture.FramedTexture;
import org.tlauncher.util.PreparedProfileManager;

public class TLSkinCape {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TLSkinCape INSTANCE = new TLSkinCape();
    private PreparedProfileManager preparedProfileManager = new PreparedProfileManager();
    private TextureManager textureManager = new TextureManager();
    private long lastTimeMills;

    public TLSkinCape() {
        this.textureManager.setPreparedProfileManager(this.preparedProfileManager);
        if (Objects.nonNull(System.getProperty("memoryLeakTest"))) {
            this.testMemoryLeak();
        }
    }

    public static String getSkinType(GameProfile gameProfile) {
        PlayerName p = new PlayerName(gameProfile);
        ProfileTexture profileTexture = INSTANCE.getTextureManager().get(p);
        if (Objects.nonNull(profileTexture)) {
            String skinType = profileTexture.getSkinType();
            if ("slim".equals(profileTexture.getSkinType())) {
                return skinType;
            }
        }
        return "default";
    }

    public static ResourceLocation getLocationCape(GameProfile gameProfile) {
        PlayerName p = new PlayerName(gameProfile);
        if (INSTANCE.getTextureManager().isInit(p, MinecraftProfileTexture.Type.CAPE)) {
            FramedTexture framedTexture = INSTANCE.getTextureManager().get(p).getCape();
            if (Objects.nonNull(framedTexture)) {
                return framedTexture.getFrame();
            }
        } else {
            INSTANCE.createTexture(gameProfile, p);
        }
        return null;
    }

    public static ResourceLocation getLocationSkin(GameProfile gameProfile) {
        PlayerName p = new PlayerName(gameProfile);
        if (INSTANCE.getTextureManager().isInit(p, MinecraftProfileTexture.Type.SKIN)) {
            ResourceLocation resourceLocation = INSTANCE.getTextureManager().get(p).getSkin();
            if (Objects.nonNull(resourceLocation)) {
                return resourceLocation;
            }
        } else {
            INSTANCE.createTexture(gameProfile, p);
        }
        return DefaultPlayerSkin.func_177335_a();
    }

    private void createTexture(GameProfile p, PlayerName name) {
        if (System.currentTimeMillis() - this.lastTimeMills >= 90L) {
            this.preparedProfileManager.addNewName(p, name);
            this.textureManager.createFramedTextures();
            this.lastTimeMills = System.currentTimeMillis();
        }
    }

    private TextureManager getTextureManager() {
        return this.textureManager;
    }

    private void testMemoryLeak() {
        int name = 0;
        int i = 100;
        LOGGER.info("started testing memory leak");
        for (int j = 0; j < 20; ++j) {
            for (int k = 0; k < i; ++k) {
                this.preparedProfileManager.addNewName(new PlayerName("test" + name++));
                for (int l = 0; l < 100; ++l) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.textureManager.createFramedTextures();
                }
            }
            LOGGER.info("finished cycle: " + j);
        }
        LOGGER.info("finished testing memory leak");
    }
}

