/*
 * Decompiled with CFR 0.152.
 */
package third_party.com.facebook.yoga;

public class YogaMath {
    public static float Max(float a, float b) {
        if (!Float.isNaN(a) && !Float.isNaN(b)) {
            return Math.max(a, b);
        }
        return Float.isNaN(a) ? b : a;
    }

    public static float Min(float a, float b) {
        if (!Float.isNaN(a) && !Float.isNaN(b)) {
            return Math.min(a, b);
        }
        return Float.isNaN(a) ? b : a;
    }

    public static float RoundValueToPixelGrid(float value, float pointScaleFactor, boolean forceCeil, boolean forceFloor) {
        float scaledValue = value * pointScaleFactor;
        float fractial = scaledValue % 1.0f;
        if (fractial < 0.0f) {
            fractial += 1.0f;
        }
        scaledValue = YogaMath.FloatsEqual(fractial, 0.0f) ? (scaledValue -= fractial) : (YogaMath.FloatsEqual(fractial, 1.0f) ? scaledValue - fractial + 1.0f : (forceCeil ? scaledValue - fractial + 1.0f : (forceFloor ? (scaledValue -= fractial) : scaledValue - fractial + (!Float.isNaN(fractial) && (fractial > 0.5f || YogaMath.FloatsEqual(fractial, 0.5f)) ? 1.0f : 0.0f))));
        return Float.isNaN(scaledValue) || Float.isNaN(pointScaleFactor) ? Float.NaN : scaledValue / pointScaleFactor;
    }

    public static boolean FloatsEqual(float a, float b) {
        if (Float.isNaN(a)) {
            return Float.isNaN(b);
        }
        if (Float.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) < 1.0E-4f;
    }
}

