/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.schedule;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import snownee.kiwi.Kiwi;
import snownee.kiwi.schedule.ITicker;
import snownee.kiwi.schedule.Task;

@Mod.EventBusSubscriber
public final class Scheduler
extends WorldSavedData {
    public static final String ID = "kiwi-schedule";
    public static final Scheduler INSTANCE = new Scheduler();
    private static final Map<ResourceLocation, Class<Task>> idToTask = Maps.newHashMap();
    private static final Map<Class<Task>, ResourceLocation> taskToId = Maps.newHashMap();
    protected static final Multimap<ITicker, Task> taskMap = LinkedListMultimap.create();

    private Scheduler() {
        super(ID);
    }

    public static void register(ResourceLocation id, Class<? extends Task> clazz) {
        if (idToTask.containsKey(id)) {
            Kiwi.logger.error("Duplicate task id: " + id);
        } else if (taskToId.containsKey(clazz)) {
            Kiwi.logger.error("Duplicate task class: " + clazz);
        } else if (!INBTSerializable.class.isAssignableFrom(clazz)) {
            Kiwi.logger.error("task " + id + " should implement INBTSerializable");
        } else {
            idToTask.put(id, clazz);
            taskToId.put(clazz, id);
        }
    }

    public Task deserialize(CompoundNBT data) {
        try {
            ResourceLocation type = new ResourceLocation(data.func_74779_i("type"));
            Class<Task> clazz = idToTask.get(type);
            if (clazz != null) {
                Task task = clazz.newInstance();
                ((INBTSerializable)task).deserializeNBT((INBT)data);
                return task;
            }
        }
        catch (Exception e) {
            Kiwi.logger.catching((Throwable)e);
        }
        return null;
    }

    public CompoundNBT serialize(Task task) {
        if (task.shouldSave()) {
            try {
                ResourceLocation type = taskToId.get(task.getClass());
                CompoundNBT data = (CompoundNBT)((INBTSerializable)task).serializeNBT();
                data.func_74778_a("type", type.toString());
                return data;
            }
            catch (Exception e) {
                Kiwi.logger.catching((Throwable)e);
            }
        }
        return null;
    }

    public static void add(Task<?> task) {
        Object ticker = task.ticker();
        if (ticker != null) {
            taskMap.put(ticker, task);
        }
    }

    public static void remove(Task<?> task) {
        taskMap.values().remove(task);
    }

    public static <T extends ITicker> void tick(T ticker) {
        Iterator itr = taskMap.get(ticker).iterator();
        while (itr.hasNext()) {
            Task task = (Task)itr.next();
            if (!task.tick(ticker)) continue;
            itr.remove();
        }
    }

    public boolean func_76188_b() {
        return !taskMap.isEmpty();
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT list = nbt.func_150295_c("tasks", 10);
        for (int i = 0; i < list.size(); ++i) {
            Task task = this.deserialize(list.func_150305_b(i));
            if (task == null) continue;
            Scheduler.add(task);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT data) {
        ListNBT list = new ListNBT();
        for (Task task : taskMap.values()) {
            CompoundNBT nbt = this.serialize(task);
            if (nbt == null) continue;
            list.add((Object)nbt);
        }
        if (!list.isEmpty()) {
            data.func_218657_a("tasks", (INBT)list);
        }
        return data;
    }

    public static void clear() {
        taskMap.keySet().forEach(ITicker::destroy);
        taskMap.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void clientLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Scheduler.clear();
    }

    @SubscribeEvent
    public static void serverStopped(FMLServerStoppedEvent event) {
        Scheduler.clear();
    }
}

