/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.crafting;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

public abstract class DynamicShapedRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private final int recipeWidth;
    private final int recipeHeight;
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack recipeOutput;
    private final ResourceLocation id;
    private final String group;

    public DynamicShapedRecipe(ResourceLocation idIn, String groupIn, int recipeWidthIn, int recipeHeightIn, NonNullList<Ingredient> ingredients, ItemStack recipeOutputIn) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeWidth = recipeWidthIn;
        this.recipeHeight = recipeHeightIn;
        this.recipeItems = ingredients;
        this.recipeOutput = recipeOutputIn;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.getMatchPos(inv) != null;
    }

    @Nullable
    public int[] getMatchPos(CraftingInventory inv) {
        for (int x = 0; x <= inv.func_174922_i() - this.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.func_174923_h() - this.getRecipeHeight(); ++y) {
                if (!this.checkMatch(inv, x, y) || !this.checkEmpty(inv, x, y)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public abstract ItemStack getCraftingResult(CraftingInventory var1);

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public int getRecipeWidth() {
        return this.recipeWidth;
    }

    public int getRecipeHeight() {
        return this.recipeHeight;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.getRecipeWidth() && height >= this.getRecipeHeight();
    }

    public String func_193358_e() {
        return this.group;
    }

    public boolean func_192399_d() {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public abstract IRecipeSerializer<?> func_199559_b();

    protected boolean checkMatch(CraftingInventory inv, int startX, int startY) {
        for (int y = startY; y < startY + this.getRecipeHeight(); ++y) {
            for (int x = startX; x < startX + this.getRecipeWidth(); ++x) {
                if (this.matches(inv, x, y, x - startX, y - startY)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(CraftingInventory inv, int x, int y, int ix, int iy) {
        Ingredient ingredient = (Ingredient)this.recipeItems.get(ix + iy * this.getRecipeWidth());
        return ingredient.test(inv.func_70301_a(x + y * inv.func_174922_i()));
    }

    protected boolean checkEmpty(CraftingInventory inv, int startX, int startY) {
        for (int y = 0; y < inv.func_174923_h(); ++y) {
            int subY = y - startY;
            for (int x = 0; x < inv.func_174922_i(); ++x) {
                int subX = x - startX;
                if (subX >= 0 && subY >= 0 && subX < this.getRecipeWidth() && subY < this.getRecipeHeight() || this.getEmpty().test(inv.func_70301_a(x + y * inv.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    protected Predicate<ItemStack> getEmpty() {
        return Ingredient.field_193370_a;
    }
}

