/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.client.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class TextureMultipart
implements IDynamicBakedModel {
    private final List<Pair<Predicate<BlockState>, IBakedModel>> selectors;
    private final IBakedModel originalBaked;
    private final Map<BlockState, BitSet> field_210277_g = new Object2ObjectOpenCustomHashMap(Util.func_212443_g());

    public TextureMultipart(List<Pair<Predicate<BlockState>, IBakedModel>> p_i48273_1_) {
        this.selectors = p_i48273_1_;
        this.originalBaked = (IBakedModel)p_i48273_1_.iterator().next().getRight();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (state == null) {
            return Collections.emptyList();
        }
        BitSet bitset = this.field_210277_g.get(state);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                Pair<Predicate<BlockState>, IBakedModel> pair = this.selectors.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitset.set(i);
            }
            this.field_210277_g.put(state, bitset);
        }
        ArrayList list = Lists.newArrayList();
        long k = rand.nextLong();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            list.addAll(((IBakedModel)this.selectors.get(j).getRight()).getQuads(state, side, new Random(k), extraData));
        }
        return list;
    }

    public boolean func_177555_b() {
        return this.originalBaked.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.originalBaked.func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.originalBaked.func_177554_e();
    }

    public TextureAtlasSprite getParticleTexture(IModelData data) {
        return this.originalBaked.getParticleTexture(data);
    }

    public ItemCameraTransforms func_177552_f() {
        return this.originalBaked.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return this.originalBaked.func_188617_f();
    }

    public boolean func_230044_c_() {
        return this.originalBaked.func_230044_c_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final List<Pair<Predicate<BlockState>, IBakedModel>> selectors = Lists.newArrayList();

        public void putModel(Predicate<BlockState> predicate, IBakedModel model) {
            this.selectors.add((Pair<Predicate<BlockState>, IBakedModel>)Pair.of(predicate, (Object)model));
        }

        public IBakedModel build() {
            return new TextureMultipart(this.selectors);
        }
    }
}

