/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import snownee.kiwi.Kiwi;
import snownee.kiwi.util.ReflectionUtil;

public class KiwiObjectHolderRef
implements Consumer<Predicate<ResourceLocation>> {
    private final Field field;
    private final ResourceLocation injectedObject;
    private final IForgeRegistry<?> registry;

    public KiwiObjectHolderRef(@Nullable Field field, ResourceLocation injectedObject, IForgeRegistry<?> registry) {
        this.field = field;
        this.injectedObject = injectedObject;
        this.registry = registry;
    }

    @Override
    public void accept(Predicate<ResourceLocation> filter) {
        if (this.field == null || !filter.test(this.registry.getRegistryName())) {
            return;
        }
        if (!this.registry.containsKey(this.injectedObject)) {
            Kiwi.logger.debug("Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        IForgeRegistryEntry thing = this.registry.getValue(this.injectedObject);
        try {
            ReflectionUtil.setFinalValue(this.field, null, thing);
        }
        catch (Exception e) {
            Kiwi.logger.warn("Unable to set {} with value {} ({})", (Object)this.field, (Object)thing, (Object)this.injectedObject, (Object)e);
        }
    }

    public KiwiObjectHolderRef withField(Field field) {
        return new KiwiObjectHolderRef(field, this.injectedObject, this.registry);
    }

    public Class getRegistryType() {
        return this.registry.getRegistrySuperType();
    }

    public int hashCode() {
        if (this.field == null) {
            return this.registry.hashCode() * 31 + this.injectedObject.hashCode();
        }
        return this.field.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof KiwiObjectHolderRef)) {
            return false;
        }
        KiwiObjectHolderRef o = (KiwiObjectHolderRef)other;
        if (this.field == null) {
            return this.registry.equals(o.registry) && this.injectedObject.equals((Object)o.injectedObject);
        }
        return this.field.equals(o.field);
    }
}

