/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.container.UContainer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class BufferPropertyContainerMessage {
    private final int id;
    private final int property;
    private final PacketBuffer buffer;

    public BufferPropertyContainerMessage(int id, int property, PacketBuffer buffer) {
        this.id = id;
        this.property = property;
        this.buffer = buffer;
    }

    public static void encode(BufferPropertyContainerMessage message, PacketBuffer sendBuffer) {
        sendBuffer.writeByte(message.id);
        sendBuffer.writeShort(message.property);
        sendBuffer.writeBytes((ByteBuf)message.buffer);
    }

    public static BufferPropertyContainerMessage decode(PacketBuffer sendBuffer) {
        byte id = sendBuffer.readByte();
        short property = sendBuffer.readShort();
        byte[] bytes = new byte[sendBuffer.readableBytes()];
        sendBuffer.getBytes(sendBuffer.readerIndex(), bytes);
        BufferPropertyContainerMessage buffer = new BufferPropertyContainerMessage(id, property, new PacketBuffer(Unpooled.wrappedBuffer((byte[])bytes)));
        return buffer;
    }

    public int getProperty() {
        return this.property;
    }

    public PacketBuffer getBuffer() {
        return this.buffer;
    }

    public static class Handler {
        public static void handle(BufferPropertyContainerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                    Handler.handleClient(message);
                } else {
                    Handler.handleServer(message, context);
                }
            });
            context.setPacketHandled(true);
        }

        private static void handleServer(BufferPropertyContainerMessage message, NetworkEvent.Context context) {
            Handler.getUContainer(context.getSender().field_71070_bA, message.id).ifPresent(container -> container.updateValue(message, LogicalSide.SERVER));
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void handleClient(BufferPropertyContainerMessage message) {
            Handler.getUContainer(Minecraft.func_71410_x().field_71439_g.field_71070_bA, message.id).ifPresent(container -> container.updateValue(message, LogicalSide.CLIENT));
        }

        private static final Optional<UContainer> getUContainer(Container container, int id) {
            if (container instanceof UContainer && container.field_75152_c == id) {
                return Optional.of((UContainer)container);
            }
            return Optional.empty();
        }
    }
}

