/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class VehicleCrateTileEntity
extends TileEntitySynced
implements ITickableTileEntity {
    private static final Random RAND = new Random();
    private ResourceLocation entityId;
    private int color = VehicleEntity.DYE_TO_COLOR[0];
    private EngineTier engineTier = null;
    private WheelType wheelType = null;
    private int wheelColor = -1;
    private boolean opened = false;
    private int timer;
    private UUID opener;
    @OnlyIn(value=Dist.CLIENT)
    private Entity entity;

    public VehicleCrateTileEntity() {
        super((TileEntityType)ModTileEntities.VEHICLE_CRATE.get());
    }

    public void setEntityId(ResourceLocation entityId) {
        this.entityId = entityId;
        this.func_70296_d();
    }

    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    public void open(UUID opener) {
        if (this.entityId != null) {
            this.opened = true;
            this.opener = opener;
            this.syncToClient();
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getTimer() {
        return this.timer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public <E extends Entity> E getEntity() {
        return (E)this.entity;
    }

    public void func_73660_a() {
        if (this.opened) {
            this.timer += 5;
            if (this.field_145850_b.field_72995_K) {
                if (this.entityId != null && this.entity == null) {
                    EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.entityId);
                    if (entityType != null) {
                        this.entity = entityType.func_200721_a(this.field_145850_b);
                        if (this.entity != null) {
                            VehicleMod.PROXY.playSound(SoundEvents.field_187635_cQ, this.field_174879_c, 1.0f, 0.5f);
                            List entryList = this.entity.func_184212_Q().func_187231_c();
                            if (entryList != null) {
                                entryList.forEach(dataEntry -> this.entity.func_184206_a(dataEntry.func_187205_a()));
                            }
                            if (this.entity instanceof VehicleEntity) {
                                ((VehicleEntity)this.entity).setColor(this.color);
                            }
                            if (this.entity instanceof PoweredVehicleEntity) {
                                PoweredVehicleEntity entityPoweredVehicle = (PoweredVehicleEntity)this.entity;
                                if (this.engineTier != null) {
                                    entityPoweredVehicle.setEngine(true);
                                    entityPoweredVehicle.setEngineTier(this.engineTier);
                                }
                                if (this.wheelType != null) {
                                    entityPoweredVehicle.setWheels(true);
                                    entityPoweredVehicle.setWheelType(this.wheelType);
                                    if (this.wheelColor != -1) {
                                        entityPoweredVehicle.setWheelColor(this.wheelColor);
                                    }
                                } else {
                                    entityPoweredVehicle.setWheels(false);
                                }
                            }
                        } else {
                            this.entityId = null;
                        }
                    } else {
                        this.entityId = null;
                    }
                }
                if (this.timer == 90 || this.timer == 110 || this.timer == 130 || this.timer == 150) {
                    float pitch = (float)((double)0.9f + (double)0.2f * RAND.nextDouble());
                    VehicleMod.PROXY.playSound((SoundEvent)ModSounds.VEHICLE_CRATE_PANEL_LAND.get(), this.field_174879_c, 1.0f, pitch);
                }
                if (this.timer == 150) {
                    VehicleMod.PROXY.playSound(SoundEvents.field_187539_bB, this.field_174879_c, 1.0f, 1.0f);
                    this.field_145850_b.func_195590_a((IParticleData)ParticleTypes.field_197626_s, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (!this.field_145850_b.field_72995_K && this.timer > 250) {
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                Direction facing = (Direction)state.func_177229_b((IProperty)BlockVehicleCrate.DIRECTION);
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(this.entityId);
                if (entityType != null) {
                    Entity entity = entityType.func_200721_a(this.field_145850_b);
                    if (entity != null) {
                        if (entity instanceof VehicleEntity) {
                            ((VehicleEntity)entity).setColor(this.color);
                        }
                        if (this.opener != null && entity instanceof PoweredVehicleEntity) {
                            PoweredVehicleEntity poweredVehicle = (PoweredVehicleEntity)entity;
                            poweredVehicle.setOwner(this.opener);
                            if (this.engineTier != null) {
                                poweredVehicle.setEngine(true);
                                poweredVehicle.setEngineTier(this.engineTier);
                            }
                            if (this.wheelType != null) {
                                poweredVehicle.setWheelType(this.wheelType);
                                if (this.wheelColor != -1) {
                                    poweredVehicle.setWheelColor(this.wheelColor);
                                }
                            }
                        }
                        entity.func_70080_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, (float)facing.func_176736_b() * 90.0f + 180.0f, 0.0f);
                        entity.func_70034_d((float)facing.func_176736_b() * 90.0f + 180.0f);
                        this.field_145850_b.func_217376_c(entity);
                    }
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Vehicle", 8)) {
            this.entityId = new ResourceLocation(compound.func_74779_i("Vehicle"));
        }
        if (compound.func_150297_b("Color", 3)) {
            this.color = compound.func_74762_e("Color");
        }
        if (compound.func_150297_b("EngineTier", 3)) {
            this.engineTier = EngineTier.getType(compound.func_74762_e("EngineTier"));
        }
        if (compound.func_150297_b("WheelType", 3)) {
            this.wheelType = WheelType.getType(compound.func_74762_e("WheelType"));
        }
        if (compound.func_150297_b("WheelColor", 3)) {
            this.wheelColor = compound.func_74762_e("WheelColor");
        }
        if (compound.func_150297_b("Opener", 8)) {
            this.opener = compound.func_186857_a("Opener");
        }
        if (compound.func_150297_b("Opened", 1)) {
            this.opened = compound.func_74767_n("Opened");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.entityId != null) {
            compound.func_74778_a("Vehicle", this.entityId.toString());
        }
        if (this.opener != null) {
            compound.func_186854_a("Opener", this.opener);
        }
        if (this.engineTier != null) {
            compound.func_74768_a("EngineTier", this.engineTier.ordinal());
        }
        if (this.wheelType != null) {
            compound.func_74768_a("WheelType", this.wheelType.ordinal());
            if (this.wheelColor != -1) {
                compound.func_74768_a("WheelColor", this.wheelColor);
            }
        }
        compound.func_74768_a("Color", this.color);
        compound.func_74757_a("Opened", this.opened);
        return super.func_189515_b(compound);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

