/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import com.mrcrayfish.vehicle.crafting.RecipeType;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.inventory.container.FluidMixerContainer;
import com.mrcrayfish.vehicle.tileentity.IFluidTankWriter;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidMixerTileEntity
extends TileEntitySynced
implements IInventory,
ITickableTileEntity,
INamedContainerProvider,
IFluidTankWriter {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)7, (Object)ItemStack.field_190927_a);
    private FluidTank tankBlaze;
    private FluidTank tankEnderSap;
    private FluidTank tankFuelium;
    private static final int SLOT_FUEL = 0;
    public static final int SLOT_INGREDIENT = 1;
    private FluidMixerRecipe currentRecipe;
    private int remainingFuel;
    private int fuelMaxProgress;
    private int extractionProgress;
    private String customName;
    protected final IIntArray fluidMixerData;
    private final LazyOptional<?> itemHandler;

    public FluidMixerTileEntity() {
        super((TileEntityType)ModTileEntities.FLUID_MIXER.get());
        this.tankBlaze = new FluidTank(((Integer)Config.SERVER.mixerInputCapacity.get()).intValue(), this::isValidFluid);
        this.tankEnderSap = new FluidTank(((Integer)Config.SERVER.mixerInputCapacity.get()).intValue(), this::isValidFluid);
        this.tankFuelium = new FluidTank(((Integer)Config.SERVER.mixerOutputCapacity.get()).intValue(), stack -> stack.getFluid() == ModFluids.FUELIUM.get());
        this.currentRecipe = null;
        this.fluidMixerData = new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return FluidMixerTileEntity.this.extractionProgress;
                    }
                    case 1: {
                        return FluidMixerTileEntity.this.remainingFuel;
                    }
                    case 2: {
                        return FluidMixerTileEntity.this.fuelMaxProgress;
                    }
                    case 3: {
                        return FluidMixerTileEntity.this.tankBlaze.getFluidAmount();
                    }
                    case 4: {
                        return FluidMixerTileEntity.this.tankEnderSap.getFluidAmount();
                    }
                    case 5: {
                        return FluidMixerTileEntity.this.tankFuelium.getFluidAmount();
                    }
                    case 6: {
                        return FluidMixerTileEntity.this.tankBlaze.getFluid().getFluid().getRegistryName().hashCode();
                    }
                    case 7: {
                        return FluidMixerTileEntity.this.tankEnderSap.getFluid().getFluid().getRegistryName().hashCode();
                    }
                    case 8: {
                        return FluidMixerTileEntity.this.tankFuelium.getFluid().getFluid().getRegistryName().hashCode();
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                switch (index) {
                    case 0: {
                        FluidMixerTileEntity.this.extractionProgress = value;
                        break;
                    }
                    case 1: {
                        FluidMixerTileEntity.this.remainingFuel = value;
                        break;
                    }
                    case 2: {
                        FluidMixerTileEntity.this.fuelMaxProgress = value;
                        break;
                    }
                    case 3: {
                        if (FluidMixerTileEntity.this.tankBlaze.isEmpty() && FluidMixerTileEntity.this.tankBlaze.getFluid().getRawFluid() == Fluids.field_204541_a) break;
                        FluidMixerTileEntity.this.tankBlaze.getFluid().setAmount(value);
                        break;
                    }
                    case 4: {
                        if (FluidMixerTileEntity.this.tankEnderSap.isEmpty() && FluidMixerTileEntity.this.tankEnderSap.getFluid().getRawFluid() == Fluids.field_204541_a) break;
                        FluidMixerTileEntity.this.tankEnderSap.getFluid().setAmount(value);
                        break;
                    }
                    case 5: {
                        if (FluidMixerTileEntity.this.tankFuelium.isEmpty() && FluidMixerTileEntity.this.tankFuelium.getFluid().getRawFluid() == Fluids.field_204541_a) break;
                        FluidMixerTileEntity.this.tankFuelium.getFluid().setAmount(value);
                        break;
                    }
                    case 6: {
                        FluidMixerTileEntity.this.updateFluid(FluidMixerTileEntity.this.tankBlaze, value);
                        break;
                    }
                    case 7: {
                        FluidMixerTileEntity.this.updateFluid(FluidMixerTileEntity.this.tankEnderSap, value);
                        break;
                    }
                    case 8: {
                        FluidMixerTileEntity.this.updateFluid(FluidMixerTileEntity.this.tankFuelium, value);
                    }
                }
            }

            public int func_221478_a() {
                return 9;
            }
        };
        this.itemHandler = LazyOptional.of(this::createUnSidedHandler);
    }

    public int func_70302_i_() {
        return 7;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return ForgeHooks.getBurnTime((ItemStack)stack) > 0;
        }
        if (index == 1) {
            return this.isValidIngredient(stack);
        }
        return false;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack ingredient = this.func_70301_a(1);
            ItemStack fuel = this.func_70301_a(0);
            if (this.currentRecipe == null && !ingredient.func_190926_b()) {
                this.currentRecipe = this.getRecipe().orElse(null);
            } else if (!this.canMix(this.currentRecipe)) {
                this.currentRecipe = null;
                this.extractionProgress = 0;
            }
            if (this.canMix(this.currentRecipe)) {
                this.updateFuel(fuel);
                if (this.remainingFuel > 0) {
                    if (this.extractionProgress++ == (Integer)Config.SERVER.mixerMixTime.get()) {
                        FluidMixerRecipe recipe = this.currentRecipe;
                        this.tankFuelium.fill(recipe.getResult().createStack(), IFluidHandler.FluidAction.EXECUTE);
                        this.tankBlaze.drain(recipe.getFluidAmount(this.tankBlaze.getFluid().getFluid()), IFluidHandler.FluidAction.EXECUTE);
                        this.tankEnderSap.drain(recipe.getFluidAmount(this.tankEnderSap.getFluid().getFluid()), IFluidHandler.FluidAction.EXECUTE);
                        this.shrinkItem(1);
                        this.extractionProgress = 0;
                        this.currentRecipe = null;
                    }
                } else {
                    this.extractionProgress = 0;
                }
            } else {
                this.extractionProgress = 0;
            }
            if (this.remainingFuel > 0) {
                --this.remainingFuel;
                this.updateFuel(fuel);
            }
        }
    }

    private void updateFuel(ItemStack fuel) {
        if (!fuel.func_190926_b() && ForgeHooks.getBurnTime((ItemStack)fuel) > 0 && this.remainingFuel == 0 && this.canMix(this.currentRecipe)) {
            this.remainingFuel = this.fuelMaxProgress = ForgeHooks.getBurnTime((ItemStack)fuel);
            this.shrinkItem(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canMix() {
        ItemStack ingredient = this.func_70301_a(1);
        if (!(ingredient.func_190926_b() || this.tankBlaze.getFluid().isEmpty() || this.tankEnderSap.getFluid().isEmpty())) {
            if (this.currentRecipe == null) {
                this.currentRecipe = this.getRecipe().orElse(null);
            }
        } else {
            this.currentRecipe = null;
        }
        return this.currentRecipe != null && this.canMix(this.currentRecipe) && this.remainingFuel >= 0;
    }

    private void shrinkItem(int index) {
        ItemStack stack = this.func_70301_a(index);
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            this.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    private boolean canMix(@Nullable FluidMixerRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack ingredient = this.func_70301_a(1);
        if (ingredient.func_77973_b() != recipe.getIngredient().func_77973_b()) {
            return false;
        }
        if (this.tankBlaze.getFluid().isEmpty()) {
            return false;
        }
        if (this.tankEnderSap.getFluid().isEmpty()) {
            return false;
        }
        if (this.tankBlaze.getFluidAmount() < recipe.getFluidAmount(this.tankBlaze.getFluid().getFluid())) {
            return false;
        }
        if (this.tankEnderSap.getFluidAmount() < recipe.getFluidAmount(this.tankEnderSap.getFluid().getFluid())) {
            return false;
        }
        if (this.tankFuelium.getFluidAmount() >= this.tankFuelium.getCapacity()) {
            return false;
        }
        return this.tankFuelium.getFluidAmount() + recipe.getResult().getAmount() <= this.tankFuelium.getCapacity();
    }

    public void func_145839_a(CompoundNBT compound) {
        CompoundNBT tagCompound;
        super.func_145839_a(compound);
        if (compound.func_150297_b("Items", 9)) {
            this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (compound.func_150297_b("TankBlaze", 10)) {
            tagCompound = compound.func_74775_l("TankBlaze");
            this.tankBlaze.readFromNBT(tagCompound);
        }
        if (compound.func_150297_b("TankEnderSap", 10)) {
            tagCompound = compound.func_74775_l("TankEnderSap");
            this.tankEnderSap.readFromNBT(tagCompound);
        }
        if (compound.func_150297_b("TankFuelium", 10)) {
            tagCompound = compound.func_74775_l("TankFuelium");
            this.tankFuelium.readFromNBT(tagCompound);
        }
        if (compound.func_150297_b("RemainingFuel", 3)) {
            this.remainingFuel = compound.func_74762_e("RemainingFuel");
        }
        if (compound.func_150297_b("FuelMaxProgress", 3)) {
            this.fuelMaxProgress = compound.func_74762_e("FuelMaxProgress");
        }
        if (compound.func_150297_b("ExtractionProgress", 3)) {
            this.extractionProgress = compound.func_74762_e("ExtractionProgress");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        this.writeTanks(compound);
        compound.func_74768_a("RemainingFuel", this.remainingFuel);
        compound.func_74768_a("FuelMaxProgress", this.fuelMaxProgress);
        compound.func_74768_a("ExtractionProgress", this.extractionProgress);
        return compound;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189515_b(new CompoundNBT());
        this.writeTanks(tag);
        return tag;
    }

    @Override
    public void writeTanks(CompoundNBT compound) {
        CompoundNBT tagTankBlaze = new CompoundNBT();
        this.tankBlaze.writeToNBT(tagTankBlaze);
        compound.func_218657_a("TankBlaze", (INBT)tagTankBlaze);
        CompoundNBT tagTankEnderSap = new CompoundNBT();
        this.tankEnderSap.writeToNBT(tagTankEnderSap);
        compound.func_218657_a("TankEnderSap", (INBT)tagTankEnderSap);
        CompoundNBT tagTankFuelium = new CompoundNBT();
        this.tankFuelium.writeToNBT(tagTankFuelium);
        compound.func_218657_a("TankFuelium", (INBT)tagTankFuelium);
    }

    @Override
    public boolean areTanksEmpty() {
        return this.tankBlaze.isEmpty() && this.tankEnderSap.isEmpty() && this.tankFuelium.isEmpty();
    }

    private String getName() {
        return this.hasCustomName() ? this.customName : "container.fluid_mixer";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new StringTextComponent(this.getName()) : new TranslationTextComponent(this.getName(), new Object[0]);
    }

    @Nullable
    public FluidStack getBlazeFluidStack() {
        return this.tankBlaze.getFluid();
    }

    @Nullable
    public FluidStack getEnderSapFluidStack() {
        return this.tankEnderSap.getFluid();
    }

    @Nullable
    public FluidStack getFueliumFluidStack() {
        return this.tankFuelium.getFluid();
    }

    public int getExtractionProgress() {
        return this.fluidMixerData.func_221476_a(0);
    }

    public int getRemainingFuel() {
        return this.fluidMixerData.func_221476_a(1);
    }

    public int getFuelMaxProgress() {
        return this.fluidMixerData.func_221476_a(2);
    }

    public int getBlazeLevel() {
        return this.fluidMixerData.func_221476_a(3);
    }

    public int getEnderSapLevel() {
        return this.fluidMixerData.func_221476_a(4);
    }

    public int getFueliumLevel() {
        return this.fluidMixerData.func_221476_a(5);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new FluidMixerContainer(windowId, playerInventory, this);
    }

    public IIntArray getFluidMixerData() {
        return this.fluidMixerData;
    }

    public void updateFluid(FluidTank tank, int fluidHash) {
        Optional<Fluid> optional = ForgeRegistries.FLUIDS.getValues().stream().filter(fluid -> fluid.getRegistryName().hashCode() == fluidHash).findFirst();
        optional.ifPresent(fluid -> tank.setFluid(new FluidStack(fluid, tank.getFluidAmount())));
    }

    public Optional<FluidMixerRecipe> getRecipe() {
        return this.field_145850_b.func_199532_z().func_215371_a(RecipeType.FLUID_MIXER, (IInventory)this, this.field_145850_b);
    }

    private boolean isValidIngredient(ItemStack ingredient) {
        List recipes = this.field_145850_b.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == RecipeType.FLUID_MIXER).map(recipe -> (FluidMixerRecipe)recipe).collect(Collectors.toList());
        return recipes.stream().anyMatch(recipe -> InventoryUtil.areItemStacksEqualIgnoreCount(ingredient, recipe.getIngredient()));
    }

    private boolean isValidFluid(FluidStack stack) {
        List recipes = this.field_145850_b.func_199532_z().func_199510_b().stream().filter(recipe -> recipe.func_222127_g() == RecipeType.FLUID_MIXER).map(recipe -> (FluidMixerRecipe)recipe).collect(Collectors.toList());
        return recipes.stream().anyMatch(recipe -> {
            for (FluidEntry entry : recipe.getInputs()) {
                if (entry.getFluid() != stack.getFluid()) continue;
                return true;
            }
            return false;
        });
    }

    public FluidTank getEnderSapTank() {
        return this.tankEnderSap;
    }

    public FluidTank getBlazeTank() {
        return this.tankBlaze;
    }

    public FluidTank getFueliumTank() {
        return this.tankFuelium;
    }

    @Nonnull
    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_206869_a().contains(BlockRotatedObject.DIRECTION)) {
                Direction direction = (Direction)state.func_177229_b((IProperty)BlockRotatedObject.DIRECTION);
                if (facing == direction.func_176735_f()) {
                    return LazyOptional.of(() -> this.tankBlaze).cast();
                }
                if (facing == direction) {
                    return LazyOptional.of(() -> this.tankEnderSap).cast();
                }
                if (facing == direction.func_176746_e()) {
                    return LazyOptional.of(() -> this.tankFuelium).cast();
                }
            }
            return LazyOptional.empty();
        }
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

