/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.common.inventory.IStorage;
import com.mrcrayfish.vehicle.common.inventory.StorageInventory;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.StorageTrailerEntity;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import com.mrcrayfish.vehicle.network.message.MessageSyncInventory;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class SeederTrailerEntity
extends TrailerEntity
implements EntityRaytracer.IEntityRaytraceable,
IStorage {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(SeederTrailerEntity.createScaledBoundingBox(-0.4375, 0.3875, 0.375, 0.4375, 0.525, 1.0625, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = (Map)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
        HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> map = new HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList>();
        map.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        return map;
    });
    private int inventoryTimer;
    private StorageInventory inventory;

    public SeederTrailerEntity(EntityType<? extends SeederTrailerEntity> type, World worldIn) {
        super(type, worldIn);
        this.initInventory();
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return false;
    }

    @Override
    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if ((heldItem.func_190926_b() || !(heldItem.func_77973_b() instanceof SprayCanItem)) && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.getInventory(), buffer -> buffer.func_150787_b(this.func_145782_y()));
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && (Integer)Config.SERVER.trailerInventorySyncCooldown.get() > 0 && this.inventoryTimer++ == (Integer)Config.SERVER.trailerInventorySyncCooldown.get()) {
            this.inventoryTimer = 0;
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new MessageSyncInventory(this.func_145782_y(), this.inventory));
        }
    }

    @Override
    public void onUpdateVehicle() {
        super.onUpdateVehicle();
        Vec3d lookVec = this.func_70040_Z();
        this.plantSeed(lookVec.func_178785_b((float)Math.toRadians(90.0)).func_186678_a(0.85));
        this.plantSeed(Vec3d.field_186680_a);
        this.plantSeed(lookVec.func_178785_b((float)Math.toRadians(-90.0)).func_186678_a(0.85));
    }

    private void plantSeed(Vec3d vec) {
        BlockPos pos = new BlockPos(this.field_70169_q + vec.field_72450_a, this.field_70167_r + 0.25, this.field_70166_s + vec.field_72449_c);
        if (this.field_70170_p.func_175623_d(pos) && this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof FarmlandBlock) {
            ItemStack seed = this.getSeed();
            if (seed.func_190926_b() && this.getPullingEntity() instanceof StorageTrailerEntity) {
                seed = this.getSeedFromStorage((StorageTrailerEntity)this.getPullingEntity());
            }
            if (this.isSeed(seed)) {
                Block seedBlock = ((BlockNamedItem)seed.func_77973_b()).func_179223_d();
                this.field_70170_p.func_175656_a(pos, seedBlock.func_176223_P());
                seed.func_190918_g(1);
            }
        }
    }

    private ItemStack getSeed() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (!this.isSeed(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean isSeed(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof BlockNamedItem && ((BlockNamedItem)stack.func_77973_b()).func_179223_d() instanceof CropsBlock;
    }

    private ItemStack getSeedFromStorage(StorageTrailerEntity storageTrailer) {
        if (storageTrailer == null) {
            return ItemStack.field_190927_a;
        }
        if (storageTrailer.getInventory() != null) {
            StorageInventory storage = storageTrailer.getInventory();
            for (int i = 0; i < storage.func_70302_i_(); ++i) {
                ItemStack stack = storage.func_70301_a(i);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
                return stack;
            }
            if (storageTrailer.getPullingEntity() instanceof StorageTrailerEntity) {
                return this.getSeedFromStorage((StorageTrailerEntity)storageTrailer.getPullingEntity());
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Inventory", 9)) {
            this.initInventory();
            InventoryUtil.readInventoryToNBT(compound, "Inventory", this.inventory);
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.inventory != null) {
            InventoryUtil.writeInventoryToNBT(compound, "Inventory", (IInventory)this.inventory);
        }
    }

    private void initInventory() {
        StorageInventory original = this.inventory;
        this.inventory = new StorageInventory(this, 27);
        if (original != null) {
            for (int i = 0; i < original.func_70302_i_(); ++i) {
                ItemStack stack = original.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                this.inventory.func_70299_a(i, stack.func_77946_l());
            }
        }
    }

    @Override
    protected void onVehicleDestroyed(LivingEntity entity) {
        super.onVehicleDestroyed(entity);
        if (this.inventory != null) {
            InventoryHelper.func_180176_a((World)this.field_70170_p, (Entity)this, (IInventory)this.inventory);
        }
    }

    @Override
    public StorageInventory getInventory() {
        return this.inventory;
    }

    @Override
    public double getHitchOffset() {
        return -17.6;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return ImmutableList.of((Object)CONNECTION_BOX);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (rightClick && result.getPartHit() == CONNECTION_BOX) {
            PacketHandler.instance.sendToServer((Object)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public boolean isStorageItem(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b().func_206844_a(Tags.Items.SEEDS);
    }

    @Override
    public ITextComponent getStorageName() {
        return this.func_145748_c_();
    }
}

