/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mrcrayfish.vehicle.crafting.FluidEntry;
import com.mrcrayfish.vehicle.crafting.FluidMixerRecipe;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FluidMixerRecipeSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FluidMixerRecipe> {
    public FluidMixerRecipe read(ResourceLocation recipeId, JsonObject json) {
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray input = JSONUtils.func_151214_t((JsonObject)json, (String)"input");
        if (input.size() != 2) {
            throw new JsonSyntaxException("Invalid input, must only have two objects");
        }
        FluidEntry inputOne = FluidEntry.deserialize(input.get(0).getAsJsonObject());
        FluidEntry inputTwo = FluidEntry.deserialize(input.get(1).getAsJsonObject());
        ItemStack ingredient = CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("ingredient"), (boolean)false);
        FluidEntry result = FluidEntry.deserialize(json.getAsJsonObject("result"));
        return new FluidMixerRecipe(recipeId, inputOne, inputTwo, ingredient, result);
    }

    @Nullable
    public FluidMixerRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidEntry inputOne = FluidEntry.read(buffer);
        FluidEntry inputTwo = FluidEntry.read(buffer);
        ItemStack ingredient = buffer.func_150791_c();
        FluidEntry result = FluidEntry.read(buffer);
        return new FluidMixerRecipe(recipeId, inputOne, inputTwo, ingredient, result);
    }

    public void write(PacketBuffer buffer, FluidMixerRecipe recipe) {
        for (FluidEntry entry : recipe.getInputs()) {
            entry.write(buffer);
        }
        buffer.func_150788_a(recipe.getIngredient());
        recipe.getResult().write(buffer);
    }
}

