/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.google.common.collect.HashBiMap;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageSyncPlayerSeat;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.PacketDistributor;

public class SeatTracker {
    private final int maxSeatSize;
    private HashBiMap<UUID, Integer> playerSeatMap = HashBiMap.create();
    private WeakReference<VehicleEntity> vehicleRef;

    public SeatTracker(VehicleEntity entity) {
        this.maxSeatSize = entity.getProperties().getSeats().size();
        this.vehicleRef = new WeakReference<VehicleEntity>(entity);
    }

    public int getSeatIndex(UUID uuid) {
        if (this.playerSeatMap.containsKey((Object)uuid)) {
            return (Integer)this.playerSeatMap.getOrDefault((Object)uuid, (Object)-1);
        }
        return -1;
    }

    public void setSeatIndex(int index, UUID uuid) {
        if (index < 0 || index >= this.maxSeatSize) {
            return;
        }
        this.playerSeatMap.forcePut((Object)uuid, (Object)index);
        VehicleEntity vehicle = (VehicleEntity)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            PacketHandler.instance.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new MessageSyncPlayerSeat(vehicle.func_145782_y(), index, uuid));
        }
    }

    public boolean isSeatAvailable(int index) {
        if (index < 0 || index >= this.maxSeatSize) {
            return false;
        }
        if (!this.playerSeatMap.inverse().containsKey((Object)index)) {
            return true;
        }
        VehicleEntity vehicle = (VehicleEntity)((Object)this.vehicleRef.get());
        if (vehicle != null) {
            UUID uuid = (UUID)this.playerSeatMap.inverse().get((Object)index);
            return vehicle.func_184188_bt().stream().noneMatch(entity -> entity.func_110124_au().equals(uuid));
        }
        return false;
    }

    public void remove(UUID uuid) {
        this.playerSeatMap.remove((Object)uuid);
    }

    public int getNextAvailableSeat() {
        VehicleEntity vehicle = (VehicleEntity)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            VehicleProperties properties = vehicle.getProperties();
            List<Seat> seats = properties.getSeats();
            for (int i = 0; i < seats.size(); ++i) {
                if (!this.playerSeatMap.values().contains(i)) {
                    return i;
                }
                UUID uuid = (UUID)this.playerSeatMap.inverse().get((Object)i);
                if (!vehicle.func_184188_bt().stream().noneMatch(entity -> entity.func_110124_au().equals(uuid))) continue;
                this.playerSeatMap.remove((Object)uuid);
                return i;
            }
        }
        return -1;
    }

    public int getClosestAvailableSeatToPlayer(PlayerEntity player) {
        VehicleEntity vehicle = (VehicleEntity)((Object)this.vehicleRef.get());
        if (vehicle != null && !vehicle.field_70170_p.field_72995_K) {
            VehicleProperties properties = vehicle.getProperties();
            List<Seat> seats = properties.getSeats();
            if (vehicle.func_184188_bt().size() == seats.size()) {
                return -1;
            }
            int closestSeatIndex = -1;
            double closestDistance = 0.0;
            for (int i = 0; i < seats.size(); ++i) {
                if (!this.isSeatAvailable(i)) continue;
                Seat seat = seats.get(i);
                Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_216372_d(-1.0, 1.0, 1.0).func_186678_a(0.0625);
                seatVec = seatVec.func_178785_b(-vehicle.getModifiedRotationYaw() * ((float)Math.PI / 180));
                seatVec = seatVec.func_178787_e(vehicle.func_213303_ch());
                double distance = player.func_70092_e(seatVec.field_72450_a, seatVec.field_72448_b - (double)(player.func_213302_cg() / 2.0f), seatVec.field_72449_c);
                if (closestSeatIndex != -1 && !(distance < closestDistance)) continue;
                closestSeatIndex = i;
                closestDistance = distance;
            }
            return closestSeatIndex;
        }
        return -1;
    }

    public CompoundNBT write() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT list = new ListNBT();
        this.playerSeatMap.forEach((uuid, seatIndex) -> {
            CompoundNBT seatTag = new CompoundNBT();
            seatTag.func_186854_a("UUID", uuid);
            seatTag.func_74768_a("SeatIndex", seatIndex.intValue());
            list.add((Object)seatTag);
        });
        compound.func_218657_a("PlayerSeatMap", (INBT)list);
        return compound;
    }

    public void read(CompoundNBT compound) {
        if (compound.func_150297_b("PlayerSeatMap", 9)) {
            this.playerSeatMap.clear();
            ListNBT list = compound.func_150295_c("PlayerSeatMap", 10);
            list.forEach(nbt -> {
                CompoundNBT seatTag = (CompoundNBT)nbt;
                UUID uuid = seatTag.func_186857_a("UUID");
                int seatIndex = seatTag.func_74762_e("SeatIndex");
                this.playerSeatMap.put((Object)uuid, (Object)seatIndex);
            });
        }
    }

    public void write(PacketBuffer buffer) {
        buffer.func_150787_b(this.playerSeatMap.size());
        this.playerSeatMap.forEach((uuid, seatIndex) -> {
            buffer.func_179252_a(uuid);
            buffer.func_150787_b(seatIndex.intValue());
        });
    }

    public void read(PacketBuffer buffer) {
        this.playerSeatMap.clear();
        int size = buffer.func_150792_a();
        for (int i = 0; i < size; ++i) {
            UUID uuid = buffer.func_179253_g();
            int seatIndex = buffer.func_150792_a();
            this.playerSeatMap.put((Object)uuid, (Object)seatIndex);
        }
    }
}

