/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.vehicle.tileentity.FuelDrumTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FuelDrumRenderer
extends TileEntityRenderer<FuelDrumTileEntity> {
    public FuelDrumRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FuelDrumTileEntity fuelDrumTileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int lightTexture, int overlayTexture) {
        BlockRayTraceResult result;
        if (Minecraft.func_71410_x().field_71439_g.func_213453_ef() && fuelDrumTileEntity.hasFluid() && this.field_228858_b_.field_190057_j != null && this.field_228858_b_.field_190057_j.func_216346_c() == RayTraceResult.Type.BLOCK && (result = (BlockRayTraceResult)this.field_228858_b_.field_190057_j).func_216350_a().equals((Object)fuelDrumTileEntity.func_174877_v())) {
            this.drawFluidLabel(this.field_228858_b_.field_147557_n, fuelDrumTileEntity.getFluidTank(), matrixStack);
        }
    }

    private void drawFluidLabel(FontRenderer fontRendererIn, FluidTank tank, MatrixStack matrixStack) {
        if (tank.getFluid().isEmpty()) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
        RenderSystem.translated((double)0.5, (double)1.25, (double)0.5);
        RenderSystem.rotatef((float)(-Minecraft.func_71410_x().field_71439_g.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.rotatef((float)Minecraft.func_71410_x().field_71439_g.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        RenderSystem.disableTexture();
        float level = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double width = 30.0;
        double fuelWidth = width * (double)level;
        double remainingWidth = width - fuelWidth;
        double offsetWidth = width / 2.0;
        FluidStack stack = tank.getFluid();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(tank.getFluid().getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            float deltaV = maxV - minV;
            maxV = minV + deltaV * 4.0f * 0.0625f;
            float deltaU = maxU - minU;
            maxU = minU + deltaU * level;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_(-offsetWidth - 1.0, -2.0, -0.01).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth - 1.0, 5.0, -0.01).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + width + 1.0, 5.0, -0.01).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + width + 1.0, -2.0, -0.01).func_227885_a_(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.enableTexture();
            RenderSystem.translated((double)0.0, (double)0.0, (double)-0.05);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_225582_a_(-offsetWidth, -1.0, 0.0).func_225583_a_(minU, maxV).func_181675_d();
            buffer.func_225582_a_(-offsetWidth, 4.0, 0.0).func_225583_a_(minU, minV).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + fuelWidth, 4.0, 0.0).func_225583_a_(maxU, minV).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + fuelWidth, -1.0, 0.0).func_225583_a_(maxU, maxV).func_181675_d();
            tessellator.func_78381_a();
            RenderSystem.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_225582_a_(-offsetWidth + fuelWidth, -1.0, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + fuelWidth, 4.0, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + fuelWidth + remainingWidth, 4.0, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_225582_a_(-offsetWidth + fuelWidth + remainingWidth, -1.0, 0.0).func_227885_a_(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        RenderSystem.enableTexture();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        String name = stack.getDisplayName().func_150254_d();
        int nameWidth = fontRendererIn.func_78256_a(name) / 2;
        fontRendererIn.func_211126_b(name, (float)(-nameWidth), -14.0f, -1);
        RenderSystem.enableLighting();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
    }
}

