/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.vehicle.block.BlockFluidExtractor;
import com.mrcrayfish.vehicle.tileentity.FluidExtractorTileEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.ForgeHooksClient;

public class FluidExtractorRenderer
extends TileEntityRenderer<FluidExtractorTileEntity> {
    public FluidExtractorRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(FluidExtractorTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, int light, int p_225616_6_) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        Direction direction = (Direction)tileEntity.func_195044_w().func_177229_b((IProperty)BlockFluidExtractor.DIRECTION);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)direction.func_176736_b() * -90.0f - 90.0f));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        float height = (float)(12.0 * ((double)tileEntity.getFluidLevel() / (double)tileEntity.getCapacity()));
        if (height > 0.0f) {
            this.drawFluid(tileEntity, matrixStack, typeBuffer, 0.625f, 0.125f, 6.25E-4f, 0.374375f, height * 0.0625f, 0.99875f);
        }
        matrixStack.func_227865_b_();
    }

    private void drawFluid(FluidExtractorTileEntity te, MatrixStack matrixStack, IRenderTypeBuffer typeBuffer, float x, float y, float z, float width, float height, float depth) {
        Fluid fluid = te.getFluidStackTank().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = ForgeHooksClient.getFluidSprites((ILightReader)te.func_145831_w(), (BlockPos)te.func_174877_v(), (IFluidState)fluid.func_207188_f())[0];
        float minU = sprite.func_94209_e();
        float maxU = Math.min(minU + (sprite.func_94212_f() - minU) * width, sprite.func_94212_f());
        float minV = sprite.func_94206_g();
        float maxV = Math.min(minV + (sprite.func_94210_h() - minV) * height, sprite.func_94210_h());
        int waterColor = fluid.getAttributes().getColor((ILightReader)te.func_145831_w(), te.func_174877_v());
        float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(waterColor & 0xFF) / 255.0f;
        int light = this.getCombinedLight((ILightReader)te.func_145831_w(), te.func_174877_v());
        IVertexBuilder buffer = typeBuffer.getBuffer(RenderType.func_228645_f_());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, x + width, y, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        maxU = Math.min(minU + (sprite.func_94212_f() - minU) * depth, sprite.func_94212_f());
        buffer.func_227888_a_(matrix, x + width, y, z + depth).func_227885_a_(red - 0.15f, green - 0.15f, blue - 0.15f, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, z).func_227885_a_(red - 0.15f, green - 0.15f, blue - 0.15f, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red - 0.15f, green - 0.15f, blue - 0.15f, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red - 0.15f, green - 0.15f, blue - 0.15f, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        maxV = Math.min(minV + (sprite.func_94210_h() - minV) * width, sprite.func_94210_h());
        buffer.func_227888_a_(matrix, x, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, minV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z + depth).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(minU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(maxU, maxV).func_227886_a_(light).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private int getCombinedLight(ILightReader lightReader, BlockPos pos) {
        int i = WorldRenderer.func_228421_a_((ILightReader)lightReader, (BlockPos)pos);
        int j = WorldRenderer.func_228421_a_((ILightReader)lightReader, (BlockPos)pos.func_177984_a());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }
}

