/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.block;

import java.util.Random;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import snownee.kiwi.tile.TextureTile;
import snownee.snow.MainModule;
import snownee.snow.SnowClientConfig;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.ISnowVariant;
import snownee.snow.block.SnowTile;
import snownee.snow.block.state.SnowFenceBlockState;
import snownee.snow.entity.FallingSnowEntity;

public class ModSnowBlock
extends SnowBlock
implements ISnowVariant {
    public static final VoxelShape[] SNOW_SHAPES_MAGIC = new VoxelShape[]{VoxelShapes.func_197880_a(), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0)};

    public ModSnowBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (!SnowCommonConfig.thinnerBoundingBox) {
            return super.func_220071_b(state, worldIn, pos, context);
        }
        int layers = (Integer)state.func_177229_b((IProperty)field_176315_a);
        if (layers == 8 && !worldIn.func_180495_p(pos.func_177984_a()).isAir(worldIn, pos)) {
            return VoxelShapes.func_197868_b();
        }
        return SNOW_SHAPES_MAGIC[layers - 1];
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (SnowCommonConfig.snowGravity) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
            return stateIn;
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return this.isValidPosition(state, worldIn, pos, false);
    }

    public boolean isValidPosition(BlockState state, IWorldReader worldIn, BlockPos pos, boolean ignoreSelf) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        Block block = blockstate.func_177230_c();
        if (block instanceof ModSnowBlock && (Integer)blockstate.func_177229_b((IProperty)field_176315_a) == 8) {
            return true;
        }
        if (SnowCommonConfig.snowOnIce && (block == Blocks.field_150432_aD || block == Blocks.field_150403_cj) || !SnowCommonConfig.invalidSupportingBlocks.contains(block)) {
            return (ignoreSelf || state.func_185904_a().func_76222_j() || ModSnowBlock.canContainState(state)) && Block.func_208061_a((VoxelShape)blockstate.func_196952_d((IBlockReader)worldIn, pos.func_177977_b()), (Direction)Direction.UP);
        }
        return false;
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 2;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.field_72995_K) {
            return;
        }
        this.checkFallable((World)worldIn, pos, state);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!SnowCommonConfig.snowNeverMelt && worldIn.func_226658_a_(LightType.BLOCK, pos) > 11) {
            if (state.func_177230_c() == MainModule.TILE_BLOCK) {
                state.removedByPlayer((World)worldIn, pos, null, false, null);
            } else {
                ModSnowBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
            return;
        }
        if (!SnowCommonConfig.snowAccumulationDuringSnowfall && !SnowCommonConfig.snowAccumulationDuringSnowstorm) {
            return;
        }
        if (random.nextInt(8) > 0) {
            return;
        }
        BlockPos height = worldIn.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos);
        if (height.func_177956_o() != pos.func_177956_o() + 1) {
            return;
        }
        Biome biome = worldIn.func_226691_t_(pos);
        boolean flag = false;
        if (worldIn.func_72896_J() && biome.func_225486_c(pos) < 0.15f) {
            if (SnowCommonConfig.snowAccumulationDuringSnowfall) {
                flag = true;
            } else if (SnowCommonConfig.snowAccumulationDuringSnowstorm && worldIn.func_72911_I()) {
                flag = true;
            }
        }
        int layers = (Integer)state.func_177229_b((IProperty)field_176315_a);
        if (flag && layers < 8) {
            ModSnowBlock.accumulate((World)worldIn, pos, state, (w, p) -> !(w.func_180495_p(p.func_177977_b()).func_177230_c() instanceof ModSnowBlock) && w.func_226658_a_(LightType.BLOCK, p) < 10, true);
        } else if (!SnowCommonConfig.snowNeverMelt && layers > 1 && !worldIn.func_72896_J()) {
            ModSnowBlock.accumulate((World)worldIn, pos, state, (w, p) -> !(w.func_180495_p(p.func_177984_a()).func_177230_c() instanceof ModSnowBlock), false);
        }
    }

    private static void accumulate(World world, BlockPos pos, BlockState centerState, BiPredicate<IWorld, BlockPos> filter, boolean accumulate) {
        int i = (Integer)centerState.func_177229_b((IProperty)field_176315_a);
        for (int j = 0; j < 4; ++j) {
            BlockState state;
            Direction direction = Direction.func_176731_b((int)j);
            BlockPos pos2 = pos.func_177972_a(direction);
            if (!filter.test((IWorld)world, pos2) || !MainModule.BLOCK.func_196260_a(state = world.func_180495_p(pos2), (IWorldReader)world, pos2)) continue;
            int l = state.func_177230_c() instanceof ModSnowBlock ? (Integer)state.func_177229_b((IProperty)field_176315_a) : 0;
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                ModSnowBlock.placeLayersOn(world, pos2, 1, false, (BlockItemUseContext)new DirectionalPlaceContext(world, pos2, Direction.UP, ItemStack.field_190927_a, Direction.DOWN), false);
            } else {
                world.func_175656_a(pos2, (BlockState)state.func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(l - 1)));
            }
            return;
        }
        if (accumulate) {
            ModSnowBlock.placeLayersOn(world, pos, 1, false, (BlockItemUseContext)new DirectionalPlaceContext(world, pos, Direction.UP, ItemStack.field_190927_a, Direction.DOWN), false);
        } else {
            world.func_175656_a(pos, (BlockState)centerState.func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(i - 1)));
        }
    }

    protected boolean checkFallable(World worldIn, BlockPos pos, BlockState state) {
        BlockPos posDown = pos.func_177977_b();
        if ((worldIn.func_175623_d(posDown) || ModSnowBlock.canFallThrough(worldIn.func_180495_p(posDown), worldIn, posDown)) && pos.func_177956_o() >= 0) {
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, this.getContainedState((IBlockReader)worldIn, pos));
                FallingSnowEntity entity = new FallingSnowEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() + 0.5, (Integer)state.func_177229_b((IProperty)field_176315_a));
                worldIn.func_217376_c((Entity)entity);
            }
            return true;
        }
        return false;
    }

    public static boolean placeLayersOn(World world, BlockPos pos, int layers, boolean falling, BlockItemUseContext useContext, boolean playSound) {
        layers = MathHelper.func_76125_a((int)layers, (int)1, (int)8);
        BlockState state = world.func_180495_p(pos);
        int originLayers = 0;
        if (state.func_177230_c() instanceof ModSnowBlock) {
            originLayers = (Integer)state.func_177229_b((IProperty)field_176315_a);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers), (int)1, (int)8))));
        } else if (ModSnowBlock.canContainState(state) && state.func_196955_c((IWorldReader)world, pos)) {
            ModSnowBlock.convert((IWorld)world, pos, state, MathHelper.func_76125_a((int)layers, (int)1, (int)8), 3);
        } else if (MainModule.BLOCK.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175656_a(pos, (BlockState)MainModule.BLOCK.func_176223_P().func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)layers, (int)1, (int)8))));
        } else {
            return false;
        }
        if (falling) {
            world.func_175641_c(pos, (Block)MainModule.BLOCK, originLayers, layers);
        } else if (playSound) {
            SoundType soundtype = MainModule.BLOCK.func_220072_p(MainModule.BLOCK.func_176223_P());
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.func_177984_a();
            if (MainModule.BLOCK.func_196260_a(MainModule.BLOCK.func_176223_P(), (IWorldReader)world, pos) && world.func_180495_p(pos).func_196953_a(useContext)) {
                world.func_175656_a(pos, (BlockState)MainModule.BLOCK.func_176223_P().func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(originLayers + layers - 8), (int)1, (int)8))));
            }
        }
        return true;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        int i = (Integer)state.func_177229_b((IProperty)field_176315_a);
        if (useContext.func_195996_i().func_77973_b() == MainModule.BLOCK.func_199767_j() && i < 8) {
            if (useContext.func_196012_c() && state.func_177230_c() == MainModule.BLOCK) {
                return useContext.func_196000_l() == Direction.UP;
            }
            return true;
        }
        return SnowCommonConfig.snowAlwaysReplaceable && (Integer)state.func_177229_b((IProperty)field_176315_a) < 8 || i == 1;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int originLayers, int layers) {
        double offsetY = (double)originLayers / 8.0;
        layers *= 10;
        for (int i = 0; i < layers; ++i) {
            double d0 = this.RANDOM.nextGaussian() * 0.1;
            double d1 = this.RANDOM.nextGaussian() * 0.02;
            double d2 = this.RANDOM.nextGaussian() * 0.1;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, (double)((float)pos.func_177958_n() + this.RANDOM.nextFloat()), (double)pos.func_177956_o() + offsetY, (double)((float)pos.func_177952_p() + this.RANDOM.nextFloat()), d0, d1, d2);
        }
        SoundType soundtype = this.getSoundType(state, (IWorldReader)worldIn, pos, null);
        worldIn.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (!SnowClientConfig.particleThroughLeaves || rand.nextInt(16) > 0) {
            return;
        }
        BlockState stateDown = worldIn.func_180495_p(pos.func_177977_b());
        if (stateDown.func_203425_a(BlockTags.field_206952_E)) {
            double d0 = (double)pos.func_177958_n() + rand.nextDouble();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (double)pos.func_177952_p() + rand.nextDouble();
            worldIn.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, stateIn), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state) {
        return -1;
    }

    public static boolean canFallThrough(BlockState state, World worldIn, BlockPos pos) {
        return FallingBlock.func_185759_i((BlockState)state) && state.func_196952_d((IBlockReader)worldIn, pos).func_197766_b();
    }

    @Override
    public BlockState onShovel(BlockState state, World world, BlockPos pos) {
        int layers = (Integer)state.func_177229_b((IProperty)field_176315_a) - 1;
        if (layers > 0) {
            return (BlockState)state.func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(layers));
        }
        return this.getRaw(state, (IBlockReader)world, pos);
    }

    @Override
    public BlockState getRaw(BlockState state, IBlockReader world, BlockPos pos) {
        return this.getContainedState(world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockState state2;
        BlockItemUseContext context;
        Block block;
        if (state.func_177230_c() == MainModule.BLOCK && (block = Block.func_149634_a((Item)(context = new BlockItemUseContext(new ItemUseContext(player, handIn, hit))).func_195996_i().func_77973_b())) != null && context.func_196012_c() && (state2 = block.func_196258_a(context)) != null && ModSnowBlock.canContainState(state2) && state2.func_196955_c((IWorldReader)worldIn, pos)) {
            if (!worldIn.field_72995_K) {
                worldIn.func_180501_a(pos, state2, 48);
                int i = (Integer)state.func_177229_b((IProperty)field_176315_a);
                if (ModSnowBlock.placeLayersOn(worldIn, pos, i, false, context, true) && !player.func_184812_l_()) {
                    context.func_195996_i().func_190918_g(1);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (blockstate.func_177230_c() instanceof ModSnowBlock) {
            int i = (Integer)blockstate.func_177229_b((IProperty)field_176315_a);
            return (BlockState)blockstate.func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.func_196258_a(context);
    }

    public BlockState getContainedState(IBlockReader world, BlockPos pos) {
        return Blocks.field_150350_a.func_176223_P();
    }

    public static boolean canContainState(BlockState state) {
        if (!SnowCommonConfig.placeSnowInBlock || state.func_177230_c().hasTileEntity(state) || !state.func_204520_s().func_206888_e()) {
            return false;
        }
        Block block = state.func_177230_c();
        if (block instanceof TallGrassBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            return true;
        }
        return block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof SlabBlock && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM || block instanceof StairsBlock && state.func_177229_b((IProperty)StairsBlock.field_176308_b) == Half.BOTTOM;
    }

    public static boolean convert(IWorld world, BlockPos pos, BlockState state, int layers, int flags) {
        BlockState newState;
        if (!SnowCommonConfig.placeSnowInBlock || state.func_177230_c().hasTileEntity(state)) {
            return false;
        }
        if (state.isAir((IBlockReader)world, pos)) {
            if (state.func_177230_c() != MainModule.BLOCK) {
                world.func_180501_a(pos, (BlockState)MainModule.BLOCK.func_176223_P().func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(layers)), flags);
            }
            return true;
        }
        Block block = state.func_177230_c();
        if (block instanceof TallGrassBlock || block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof MushroomBlock || block instanceof SweetBerryBushBlock) {
            TileEntity tile;
            if (state.func_177230_c() != MainModule.TILE_BLOCK) {
                world.func_180501_a(pos, (BlockState)MainModule.TILE_BLOCK.func_176223_P().func_206870_a((IProperty)field_176315_a, (Comparable)Integer.valueOf(layers)), flags);
            }
            if ((tile = world.func_175625_s(pos)) instanceof SnowTile) {
                ((SnowTile)tile).setState(state);
            }
            return true;
        }
        BlockPos posDown = pos.func_177977_b();
        BlockState stateDown = world.func_180495_p(posDown);
        if (block instanceof StairsBlock && state.func_177230_c() != MainModule.STAIRS) {
            world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)MainModule.STAIRS.func_176223_P().func_206870_a((IProperty)StairsBlock.field_176309_a, state.func_177229_b((IProperty)StairsBlock.field_176309_a))).func_206870_a((IProperty)StairsBlock.field_176308_b, state.func_177229_b((IProperty)StairsBlock.field_176308_b))).func_206870_a((IProperty)StairsBlock.field_176310_M, state.func_177229_b((IProperty)StairsBlock.field_176310_M)), flags);
        } else if (block instanceof SlabBlock && state.func_177230_c() != MainModule.SLAB && state.func_177229_b((IProperty)SlabBlock.field_196505_a) == SlabType.BOTTOM) {
            world.func_180501_a(pos, MainModule.SLAB.func_176223_P(), flags);
        } else if (block instanceof FenceBlock && state.func_177230_c() != MainModule.FENCE) {
            SnowFenceBlockState.setCachedMaterial((IWorldReader)world, pos, state.func_185904_a());
            newState = (BlockState)((BlockState)((BlockState)((BlockState)MainModule.FENCE.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196409_a, state.func_177229_b((IProperty)FourWayBlock.field_196409_a))).func_206870_a((IProperty)FourWayBlock.field_196413_c, state.func_177229_b((IProperty)FourWayBlock.field_196413_c))).func_206870_a((IProperty)FourWayBlock.field_196414_y, state.func_177229_b((IProperty)FourWayBlock.field_196414_y))).func_206870_a((IProperty)FourWayBlock.field_196411_b, state.func_177229_b((IProperty)FourWayBlock.field_196411_b));
            newState = newState.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState, flags);
            SnowFenceBlockState.clearCachedMaterial((IWorldReader)world, pos);
        } else if (block instanceof FenceGateBlock && state.func_177230_c() != MainModule.FENCE_GATE) {
            newState = (BlockState)((BlockState)((BlockState)MainModule.FENCE_GATE.func_176223_P().func_206870_a((IProperty)FenceGateBlock.field_176466_a, state.func_177229_b((IProperty)FenceGateBlock.field_176466_a))).func_206870_a((IProperty)FenceGateBlock.field_176467_M, state.func_177229_b((IProperty)FenceGateBlock.field_176467_M))).func_206870_a((IProperty)HorizontalBlock.field_185512_D, state.func_177229_b((IProperty)HorizontalBlock.field_185512_D));
            newState = newState.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState, flags);
        } else if (block instanceof WallBlock && state.func_177230_c() != MainModule.WALL) {
            newState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)MainModule.WALL.func_176223_P().func_206870_a((IProperty)FourWayBlock.field_196411_b, state.func_177229_b((IProperty)FourWayBlock.field_196411_b))).func_206870_a((IProperty)FourWayBlock.field_196414_y, state.func_177229_b((IProperty)FourWayBlock.field_196414_y))).func_206870_a((IProperty)FourWayBlock.field_196413_c, state.func_177229_b((IProperty)FourWayBlock.field_196413_c))).func_206870_a((IProperty)FourWayBlock.field_196409_a, state.func_177229_b((IProperty)FourWayBlock.field_196409_a))).func_206870_a((IProperty)WallBlock.field_176256_a, state.func_177229_b((IProperty)WallBlock.field_176256_a));
            newState = newState.func_196956_a(Direction.DOWN, stateDown, world, pos, posDown);
            world.func_180501_a(pos, newState, flags);
        } else {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TextureTile) {
            ((TextureTile)tile).setTexture("0", state);
        }
        return true;
    }
}

